/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.test;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCRLUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLKeyStore {
    private KeyStore serverKeyStore;
    private char[] password;
    private KeyStore trustKeyStore;
    private PrivateKey rootKey;
    private X509Certificate rootCert;
    private PrivateKey signKey;
    private X509Certificate signCert;
    private PrivateKey encKey;
    private X509Certificate encCert;

    public GMSSLKeyStore(String password, PrivateKey rootKey, X509Certificate rootCert, PrivateKey signKey, X509Certificate signCert, PrivateKey encKey, X509Certificate encCert) throws NoSuchAlgorithmException, CertificateException, NoSuchProviderException, KeyStoreException, IOException {
        this.password = password.toCharArray();
        this.rootKey = rootKey;
        this.rootCert = rootCert;
        this.signKey = signKey;
        this.signCert = signCert;
        this.encKey = encKey;
        this.encCert = encCert;
        if (rootCert.getSigAlgName().contains("SM")) {
            this.serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore((String)password, (X509Certificate)rootCert, (String)"sign", (PrivateKey)signKey, (X509Certificate)signCert, (String)"enc", (PrivateKey)encKey, (X509Certificate)encCert);
            this.trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStore((X509Certificate)rootCert);
        } else {
            this.serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithJKS((String)password, (X509Certificate)rootCert, (String)"sign", (PrivateKey)signKey, (X509Certificate)signCert, (String)"enc", (PrivateKey)encKey, (X509Certificate)encCert);
            this.trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithJKS((X509Certificate)rootCert);
        }
    }

    public KeyStore getServerKeyStore() {
        return this.serverKeyStore;
    }

    public char[] getPassword() {
        return this.password;
    }

    public KeyStore getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public PrivateKey getRootKey() {
        return this.rootKey;
    }

    public X509Certificate getRootCert() {
        return this.rootCert;
    }

    public PrivateKey getSignKey() {
        return this.signKey;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }

    public PrivateKey getEncKey() {
        return this.encKey;
    }

    public X509Certificate getEncCert() {
        return this.encCert;
    }

    public void save() throws Exception {
        File pathf = new File("." + File.separator + "target" + File.separator + "tomcat" + File.separator + "cert");
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String path = pathf.getAbsolutePath() + File.separator;
        FileOutputStream trustOut = new FileOutputStream(path + "trust.keystore");
        this.getTrustKeyStore().store(trustOut, this.getPassword());
        trustOut.close();
        FileOutputStream serverOut = new FileOutputStream(path + "server.keystore");
        this.getServerKeyStore().store(serverOut, this.getPassword());
        serverOut.close();
    }

    public static GMSSLKeyStore generateGMSSLKeyStoreByBC() throws Exception {
        String path = "gmssl-test\\gmssl-test-ssl\\target\\";
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        String rootDN = "cn=sub,o=xdja,c=cn";
        KeyPair rootKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        System.out.println(rootKeyPair.getPublic());
        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)rootKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        GMSSLX509Utils.printPEMObject((String)"sub", (Object)rootCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sub", (X509Certificate)rootCert);
        String signDN = "cn=sign,o=xdja,c=cn";
        KeyPair signKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        signExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)signKeyPair.getPublic()));
        signExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate signCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)signKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"signCert", (X509Certificate)signCert);
        String encDN = "cn=enc,o=xdja,c=cn";
        KeyPair encKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        encExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)encKeyPair.getPublic()));
        encExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)encKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"encCert", (X509Certificate)encCert);
        return new GMSSLKeyStore("password", rootKeyPair.getPrivate(), rootCert, signKeyPair.getPrivate(), signCert, encKeyPair.getPrivate(), encCert);
    }

    public static GMSSLKeyStore generateGMSSLKeyStoreByBCWithRSA() throws Exception {
        String path = "gmssl-test\\gmssl-test-ssl\\target\\rsa\\";
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        String rootDN = "cn=sub,o=xdja,c=cn";
        KeyPair rootKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        System.out.println(rootKeyPair.getPublic());
        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)rootKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), rootExtensions);
        GMSSLX509Utils.printPEMObject((String)"sub", (Object)rootCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sub", (X509Certificate)rootCert);
        String signDN = "cn=sign,o=xdja,c=cn";
        KeyPair signKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        signExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)signKeyPair.getPublic()));
        signExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate signCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)signKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), signExtensions);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"signCert", (X509Certificate)signCert);
        String encDN = "cn=enc,o=xdja,c=cn";
        KeyPair encKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        encExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)encKeyPair.getPublic()));
        encExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)encKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), encExtensions);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"encCert", (X509Certificate)encCert);
        return new GMSSLKeyStore("password", rootKeyPair.getPrivate(), rootCert, signKeyPair.getPrivate(), signCert, encKeyPair.getPrivate(), encCert);
    }

    public static GMSSLKeyStore generateGMSSLKeyStoreByBCWithSubCA() throws Exception {
        String path = "gmssl-test\\gmssl-test-ssl\\target\\";
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        String rDN = "cn=root,o=xdja,c=cn";
        KeyPair rKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> rExtensions = new ArrayList<Extension>();
        rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)rKeyPair.getPublic()));
        rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
        X509Certificate rCert = GMSSLCertUtils.generateCertByBC((String)rDN, (String)rDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rKeyPair.getPrivate(), (PublicKey)rKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rExtensions);
        GMSSLX509Utils.printPEMObject((String)"root", (Object)rCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"root", (X509Certificate)rCert);
        X509CRL x509CRL = GMSSLCRLUtils.generateCRLByBC((X509Certificate)rCert, (PrivateKey)rKeyPair.getPrivate(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)now, (Date)noAfter, null, null);
        GMSSLX509Utils.printPEMObject((String)"crl", (Object)x509CRL);
        String rootDN = "cn=sub,o=xdja,c=cn";
        KeyPair rootKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rootExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)rootKeyPair.getPublic()));
        rootExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rCert));
        rootExtensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension((String)"ldap://11.12.110.92:389/CN=caroot,OU=ll,C=cn?userCertificate;binary", (String)"http://11.12.110.90:8081/ocsp-web/ocsp/v1"));
        rootExtensions.add(GMSSLExtensionUtils.genSubjectInfoAccessExtension((String)"ldap://11.12.110.92:389/CN=withto,OU=baba,C=cn,OU=ll,C=cn?userCertificate;binary", (String)"http://11.12.110.90:8081/ocsp-web/ocsp/v1"));
        rootExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)2));
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(7, "1.1.1.1");
        Extension subjectAlternativeName = GMSSLExtensionUtils.genSubjectAlternativeName((boolean)false, map);
        rootExtensions.add(subjectAlternativeName);
        HashMap<Integer, String> permittedValues = new HashMap<Integer, String>();
        permittedValues.put(7, "1.1.1.1");
        HashMap<Integer, String> excludedValues = new HashMap<Integer, String>();
        excludedValues.put(4, "OU=test");
        Extension nameConstraints = GMSSLExtensionUtils.genNameConstraints((boolean)false, permittedValues, excludedValues);
        rootExtensions.add(nameConstraints);
        Extension policyConstraints = GMSSLExtensionUtils.genPolicyConstraints((boolean)true, (String)"1", (String)"1");
        rootExtensions.add(policyConstraints);
        Extension crlDistributionPointsExtension = GMSSLExtensionUtils.genCRLDistributionPointsExtension((String)"ldap://11.12.85.57:389/cn=crl0,o=RootCRL,o=xdja,c=cn?certificateRevocationList;binary");
        rootExtensions.add(crlDistributionPointsExtension);
        Extension freshestCRL = GMSSLExtensionUtils.genFreshestCRL((String)"ldap://11.12.85.57:389/cn=crl0,o=RootCRL,o=xdja,c=cn?deltaRevocationList;binary");
        rootExtensions.add(freshestCRL);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC((String)rDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rKeyPair.getPrivate(), (PublicKey)rootKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        GMSSLX509Utils.printPEMObject((String)"sub", (Object)rootCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sub", (X509Certificate)rootCert);
        String signDN = "cn=sign,o=xdja,c=cn";
        KeyPair signKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        signExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)signKeyPair.getPublic()));
        signExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate signCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)signKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"signCert", (X509Certificate)signCert);
        String encDN = "cn=enc,o=xdja,c=cn";
        KeyPair encKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        encExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)encKeyPair.getPublic()));
        encExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)encKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"encCert", (X509Certificate)encCert);
        return new GMSSLKeyStore("password", rootKeyPair.getPrivate(), rootCert, signKeyPair.getPrivate(), signCert, encKeyPair.getPrivate(), encCert);
    }

    public static GMSSLKeyStore generateGMSSLKeyStoreByYunhsm(int privateKeyIndex, String privateKeyPassword) throws Exception {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        String rootDN = "CN=ROOTCA,O=XDJA,C=CN";
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        PublicKey rootPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)privateKeyIndex);
        SdfPrivateKey rootPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)privateKeyIndex, (String)privateKeyPassword);
        X509Certificate rootCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)rootDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)rootPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        String signDN = "CN=SIGN,O=SERVER,O=XDJA,C=CN";
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)privateKeyIndex);
        SdfPrivateKey signPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)privateKeyIndex, (String)privateKeyPassword);
        X509Certificate signCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)signDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)signPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        String encDN = "CN=ENC,O=SERVER,O=XDJA,C=CN";
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm((int)privateKeyIndex);
        SdfPrivateKey encPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)privateKeyIndex, (String)privateKeyPassword);
        X509Certificate encCert = GMSSLCertUtils.generateCertByYunhsm((String)rootDN, (String)encDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)encPublicKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        return new GMSSLKeyStore("password", (PrivateKey)rootPrivateKey, rootCert, (PrivateKey)signPrivateKey, signCert, (PrivateKey)encPrivateKey, encCert);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

