package com.xdja.pki.gmssl.tomcat.plugin;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.security.Security;
import java.util.Iterator;
import java.util.Map;

/**
 * @author sxy
 * @description
 * @date 2019年10月31日 10:01
 **/
public class XDJAServletContextListener implements ServletContextListener {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
//        HsmConnectionPool.getInstance().initConnectionPool();
    }

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized start!");
       // HsmConnectionProviderImpl.getInstance();
        GMSSLX509Utils.printEnvProperties();
        logger.info("XDJA GMSSL TOMCAT PLUGIN contextInitialized done!");
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        logger.info("XDJA GMSSL TOMCAT PLUGIN contextDestroyed start!");
        //HsmConnectionProviderImpl.getInstance().clear();
        logger.info("XDJA GMSSL TOMCAT PLUGIN contextDestroyed done!");
    }
}
