package com.xdja.pki.gmssl.tomcat.plugin;

import com.xdja.pki.gmssl.GMSSLContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.res.StringManager;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;

import javax.net.ssl.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.List;

public class XDJAJSSEUtil implements SSLUtil {

    private static final Log log = LogFactory.getLog(XDJAJSSEUtil.class);
    private static final StringManager sm = StringManager.getManager(XDJAJSSEUtil.class);

    private final SSLHostConfigCertificate certificate;
    private final SSLHostConfig sslHostConfig;

    public XDJAJSSEUtil(SSLHostConfigCertificate certificate) {
        this.certificate = certificate;
        this.sslHostConfig = certificate.getSSLHostConfig();
    }

    @Override
    public SSLContext createSSLContext(List<String> negotiableProtocols) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new XDJAJSSEGMSSLContext(sslHostConfig.getSslProtocol());
    }


    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        String password = this.certificate.getCertificateKeystorePassword();

        KeyStore ks = GMSSLContext.getKeystore(
                this.certificate.getCertificateKeystoreFile(),
                this.certificate.getCertificateKeystoreType(),
                this.certificate.getCertificateKeystoreProvider(),
                password
        );

        KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", XDJAJsseProvider.PROVIDER_NAME);
        keyMgrFact.init(ks, password.toCharArray());

        return keyMgrFact.getKeyManagers();
    }


    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        KeyStore ts = GMSSLContext.getTrustStore(
                this.sslHostConfig.getTruststoreFile(),
                this.sslHostConfig.getTruststoreType(),
                this.sslHostConfig.getTruststoreProvider(),
                this.sslHostConfig.getTruststorePassword()
        );

        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", XDJAJsseProvider.PROVIDER_NAME);
        trustMgrFact.init(ts);

        return trustMgrFact.getTrustManagers();
    }

    @Override
    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        sslSessionContext.setSessionCacheSize(sslHostConfig.getSessionCacheSize());
        sslSessionContext.setSessionTimeout(sslHostConfig.getSessionTimeout());
    }

    @Override
    public String[] getEnabledProtocols() throws IllegalArgumentException {
        return new String[]{"GMSSLv1.1"};
    }

    @Override
    public String[] getEnabledCiphers() throws IllegalArgumentException {
        return new String[]{"GMSSL_ECC_SM4_SM3"};
    }

}
