/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.xdja.pki.gmssl.tomcat.plugin;

import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;

import javax.net.ssl.SSLSession;
import java.security.Security;

/* JSSEImplementation:

   Concrete implementation class for JSSE

   @author EKR
*/

public class XDJAJSSEImplementation extends SSLImplementation {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
    }

    @Override
    public SSLSupport getSSLSupport(SSLSession sslSession) {
        return new XDJAJSSESupport(sslSession);
    }

    @Override
    public SSLUtil getSSLUtil(SSLHostConfigCertificate sslHostConfigCertificate) {
        return new XDJAJSSEUtil(sslHostConfigCertificate);
    }

    @Override
    public boolean isAlpnSupported() {
        return JreCompat.isJre9Available();
    }

}
