/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Enumerated;
import com.xdja.pki.oer.batc.BATCResponseCodeEnum;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BATCAuthorizationValidationResponseCode
extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(BATCAuthorizationValidationResponseCode.class);
    public static final Enumerated.Value OK = new Enumerated.Value(0, "ok");
    public static final Enumerated.Value CANT_PRASE = new Enumerated.Value(1, "cantparse");
    public static final Enumerated.Value BAD_CONTENTTYPE = new Enumerated.Value(2, "badcontenttype");
    public static final Enumerated.Value IMONTTHERE_CIPIENT = new Enumerated.Value(3, "imnottherecipient");
    public static final Enumerated.Value UNKNOW_ENCRYPTION_ALGORITHM = new Enumerated.Value(4, "unknownencryptionalgorithm");
    public static final Enumerated.Value DECRYPTION_FAILED = new Enumerated.Value(5, "decryptionfailed");
    public static final Enumerated.Value INVALID_AA = new Enumerated.Value(6, "invalidaa");
    public static final Enumerated.Value INVALID_AA_SIGNATURE = new Enumerated.Value(7, "invalidaasignature");
    public static final Enumerated.Value WRONGEA = new Enumerated.Value(8, "wrongea");
    public static final Enumerated.Value UNKNOWN_ITS = new Enumerated.Value(9, "unknownits");
    public static final Enumerated.Value INVALID_SIGNATURE = new Enumerated.Value(10, "invalidsignature");
    public static final Enumerated.Value INVALID_ENCRYPTION_KEY = new Enumerated.Value(11, "invalidencryptionkey");
    public static final Enumerated.Value DENIED_PERMISSIONS = new Enumerated.Value(12, "deniedpermissions");
    public static final Enumerated.Value DENIED_TOO_MANY_CERTS = new Enumerated.Value(13, "deniedtoomanycerts");
    public static final Enumerated.Value DENIED_REQUEST = new Enumerated.Value(14, "deniedrequest");

    public BATCAuthorizationValidationResponseCode(Enumerated.Value value) {
        super(value);
        this.addValueToList(OK);
        this.addValueToList(CANT_PRASE);
        this.addValueToList(BAD_CONTENTTYPE);
        this.addValueToList(IMONTTHERE_CIPIENT);
        this.addValueToList(UNKNOW_ENCRYPTION_ALGORITHM);
        this.addValueToList(DECRYPTION_FAILED);
        this.addValueToList(INVALID_AA);
        this.addValueToList(INVALID_AA_SIGNATURE);
        this.addValueToList(WRONGEA);
        this.addValueToList(UNKNOWN_ITS);
        this.addValueToList(INVALID_SIGNATURE);
        this.addValueToList(INVALID_ENCRYPTION_KEY);
        this.addValueToList(DENIED_PERMISSIONS);
        this.addValueToList(DENIED_TOO_MANY_CERTS);
        this.addValueToList(DENIED_REQUEST);
    }

    public static BATCAuthorizationValidationResponseCode getInstance(byte[] data) throws Exception {
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        Enumerated.Value value = BATCResponseCodeEnum.AuthorizationValidationResponseCode.getValue(choice.intValue());
        BATCAuthorizationValidationResponseCode responseCode = new BATCAuthorizationValidationResponseCode(value);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        responseCode.setGoal(goal);
        return responseCode;
    }
}

