/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.batc.BATCCertificateId;
import com.xdja.pki.oer.gbt.asn1.GeographicRegion;
import com.xdja.pki.oer.gbt.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.oer.gbt.asn1.SubjectAssurance;
import com.xdja.pki.oer.gbt.asn1.ValidityPeriod;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCCertificateSubjectAttributes
extends Sequence {
    private BATCCertificateId id;
    private ValidityPeriod validityPeriod;
    private GeographicRegion region;
    private SubjectAssurance assurance;
    private SequenceOfItsAidSspList appPermissions;
    private SequenceOfItsAidSspList certIssuePermissions;

    public BATCCertificateSubjectAttributes() {
        super(true, true);
    }

    public static BATCCertificateSubjectAttributes getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List integers = BitByte.setBit((int)integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCCertificateSubjectAttributes certificateSubjectAttributes = new BATCCertificateSubjectAttributes();
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            BATCCertificateId id = BATCCertificateId.getInstance(data);
            data = id.getGoal();
            certificateSubjectAttributes.setId(id);
        }
        if (integers.contains(2)) {
            ValidityPeriod validityPeriod = ValidityPeriod.getInstance((byte[])data);
            data = validityPeriod.getGoal();
            certificateSubjectAttributes.setValidityPeriod(validityPeriod);
        }
        if (integers.contains(3)) {
            GeographicRegion region = GeographicRegion.getInstance((byte[])data);
            data = region.getGoal();
            certificateSubjectAttributes.setRegion(region);
        }
        if (integers.contains(4)) {
            SubjectAssurance assurance = SubjectAssurance.getInstance((byte[])data);
            data = assurance.getGoal();
            certificateSubjectAttributes.setAssurance(assurance);
        }
        if (integers.contains(5)) {
            SequenceOfItsAidSspList appPermissions = SequenceOfItsAidSspList.getInstance((byte[])data);
            data = appPermissions.getGoal();
            certificateSubjectAttributes.setAppPermissions(appPermissions);
        }
        if (integers.contains(6)) {
            SequenceOfItsAidSspList certIssuePermissions = SequenceOfItsAidSspList.getInstance((byte[])data);
            data = certIssuePermissions.getGoal();
            certificateSubjectAttributes.setCertIssuePermissions(certIssuePermissions);
        }
        certificateSubjectAttributes.setGoal(data);
        return certificateSubjectAttributes;
    }

    public BATCCertificateId getId() {
        return this.id;
    }

    public void setId(BATCCertificateId id) {
        this.id = id;
    }

    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public GeographicRegion getRegion() {
        return this.region;
    }

    public void setRegion(GeographicRegion region) {
        this.region = region;
    }

    public SubjectAssurance getAssurance() {
        return this.assurance;
    }

    public void setAssurance(SubjectAssurance assurance) {
        this.assurance = assurance;
    }

    public SequenceOfItsAidSspList getAppPermissions() {
        return this.appPermissions;
    }

    public void setAppPermissions(SequenceOfItsAidSspList appPermissions) {
        this.appPermissions = appPermissions;
    }

    public SequenceOfItsAidSspList getCertIssuePermissions() {
        return this.certIssuePermissions;
    }

    public void setCertIssuePermissions(SequenceOfItsAidSspList certIssuePermissions) {
        this.certIssuePermissions = certIssuePermissions;
    }

    public Vector getSequenceValues() {
        Vector<BATCCertificateId> vector = new Vector<BATCCertificateId>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.id != null) {
            optionals.add(7);
        }
        if (this.validityPeriod != null) {
            optionals.add(6);
        }
        if (this.region != null) {
            optionals.add(5);
        }
        if (this.assurance != null) {
            optionals.add(4);
        }
        if (this.appPermissions != null) {
            optionals.add(3);
        }
        if (this.certIssuePermissions != null) {
            optionals.add(2);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.id);
        vector.add((BATCCertificateId)this.validityPeriod);
        vector.add((BATCCertificateId)this.region);
        vector.add((BATCCertificateId)this.assurance);
        vector.add((BATCCertificateId)this.appPermissions);
        vector.add((BATCCertificateId)this.certIssuePermissions);
        return vector;
    }
}

