/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.Choice;
import com.xdja.pki.oer.batc.BATCAuthorizationValidationRequest;
import com.xdja.pki.oer.batc.BATCAuthorizationValidationResponse;
import com.xdja.pki.oer.batc.BATCInnerATDownloadRequest;
import com.xdja.pki.oer.batc.BATCInnerATDownloadResponse;
import com.xdja.pki.oer.batc.BATCInnerAtRequest;
import com.xdja.pki.oer.batc.BATCInnerAtResponse;
import com.xdja.pki.oer.batc.BATCInnerEcRequestSignedForPop;
import com.xdja.pki.oer.batc.BATCInnerEcResponse;
import com.xdja.pki.oer.gbt.asn1.Time32;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BATCITSDataContent
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(BATCITSDataContent.class);
    private BATCInnerEcRequestSignedForPop enrolmentRequest;
    private BATCInnerEcResponse enrolmentResponse;
    private BATCInnerAtRequest authorizationRequest;
    private BATCInnerAtResponse authorizationResponse;
    private BATCAuthorizationValidationRequest authorizationValidationRequest;
    private BATCAuthorizationValidationResponse authorizationValidationResponse;
    private Time32 serverTime;
    private BATCInnerATDownloadRequest authorizationDownloadRequest;
    private BATCInnerATDownloadResponse authorizationDownloadResponse;

    public static BATCITSDataContent getInstance(byte[] data) throws Exception {
        BATCITSDataContent itsDataContent = new BATCITSDataContent();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        switch (choice.intValue()) {
            case 128: {
                BATCInnerEcRequestSignedForPop enrolmentRequest = BATCInnerEcRequestSignedForPop.getInstance(data);
                itsDataContent.setEnrolmentRequest(enrolmentRequest);
                data = enrolmentRequest.getGoal();
                break;
            }
            case 129: {
                BATCInnerEcResponse enrolmentResponse = BATCInnerEcResponse.getInstance(data);
                itsDataContent.setEnrolmentResponse(enrolmentResponse);
                data = enrolmentResponse.getGoal();
                break;
            }
            case 130: {
                BATCInnerAtRequest authorizationRequest = BATCInnerAtRequest.getInstance(data);
                itsDataContent.setAuthorizationRequest(authorizationRequest);
                data = authorizationRequest.getGoal();
                break;
            }
            case 131: {
                BATCInnerAtResponse authorizationResponse = BATCInnerAtResponse.getInstance(data);
                itsDataContent.setAuthorizationResponse(authorizationResponse);
                data = authorizationResponse.getGoal();
                break;
            }
            case 132: {
                BATCAuthorizationValidationRequest authorizationValidationRequest = BATCAuthorizationValidationRequest.getInstance(data);
                itsDataContent.setAuthorizationValidationRequest(authorizationValidationRequest);
                data = authorizationValidationRequest.getGoal();
                break;
            }
            case 133: {
                BATCAuthorizationValidationResponse authorizationValidationResponse = BATCAuthorizationValidationResponse.getInstance(data);
                itsDataContent.setAuthorizationValidationResponse(authorizationValidationResponse);
                data = authorizationValidationResponse.getGoal();
                break;
            }
            case 134: {
                Time32 serverTime = Time32.getInstance((byte[])data);
                itsDataContent.setServerTime(serverTime);
                data = serverTime.getGoal();
                break;
            }
            case 135: {
                BATCInnerATDownloadRequest authorizationDownloadRequest = BATCInnerATDownloadRequest.getInstance(data);
                itsDataContent.setAuthorizationDownloadRequest(authorizationDownloadRequest);
                data = authorizationDownloadRequest.getGoal();
                break;
            }
            case 136: {
                BATCInnerATDownloadResponse authorizationDownloadResponse = BATCInnerATDownloadResponse.getInstance(data);
                itsDataContent.setAuthorizationDownloadResponse(authorizationDownloadResponse);
                data = authorizationDownloadResponse.getGoal();
                break;
            }
            default: {
                throw new Exception("unknown the choice value: " + choice.intValue());
            }
        }
        itsDataContent.setGoal(data);
        return itsDataContent;
    }

    public BATCInnerEcRequestSignedForPop getEnrolmentRequest() {
        return this.enrolmentRequest;
    }

    public void setEnrolmentRequest(BATCInnerEcRequestSignedForPop enrolmentRequest) {
        this.enrolmentRequest = enrolmentRequest;
    }

    public BATCInnerEcResponse getEnrolmentResponse() {
        return this.enrolmentResponse;
    }

    public void setEnrolmentResponse(BATCInnerEcResponse enrolmentResponse) {
        this.addIndex(1);
        this.enrolmentResponse = enrolmentResponse;
    }

    public BATCInnerAtRequest getAuthorizationRequest() {
        return this.authorizationRequest;
    }

    public void setAuthorizationRequest(BATCInnerAtRequest authorizationRequest) {
        this.addIndex(2);
        this.authorizationRequest = authorizationRequest;
    }

    public BATCInnerAtResponse getAuthorizationResponse() {
        return this.authorizationResponse;
    }

    public void setAuthorizationResponse(BATCInnerAtResponse authorizationResponse) {
        this.addIndex(3);
        this.authorizationResponse = authorizationResponse;
    }

    public BATCAuthorizationValidationRequest getAuthorizationValidationRequest() {
        return this.authorizationValidationRequest;
    }

    public void setAuthorizationValidationRequest(BATCAuthorizationValidationRequest authorizationValidationRequest) {
        this.addIndex(4);
        this.authorizationValidationRequest = authorizationValidationRequest;
    }

    public BATCAuthorizationValidationResponse getAuthorizationValidationResponse() {
        return this.authorizationValidationResponse;
    }

    public void setAuthorizationValidationResponse(BATCAuthorizationValidationResponse authorizationValidationResponse) {
        this.addIndex(5);
        this.authorizationValidationResponse = authorizationValidationResponse;
    }

    public Time32 getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(Time32 serverTime) {
        this.addIndex(6);
        this.serverTime = serverTime;
    }

    public BATCInnerATDownloadRequest getAuthorizationDownloadRequest() {
        return this.authorizationDownloadRequest;
    }

    public void setAuthorizationDownloadRequest(BATCInnerATDownloadRequest authorizationDownloadRequest) {
        this.addIndex(7);
        this.authorizationDownloadRequest = authorizationDownloadRequest;
    }

    public BATCInnerATDownloadResponse getAuthorizationDownloadResponse() {
        return this.authorizationDownloadResponse;
    }

    public void setAuthorizationDownloadResponse(BATCInnerATDownloadResponse authorizationDownloadResponse) {
        this.addIndex(8);
        this.authorizationDownloadResponse = authorizationDownloadResponse;
    }

    public Vector getChoiceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add((Object)this.enrolmentRequest);
        vector.add((Object)this.enrolmentResponse);
        vector.add((Object)this.authorizationRequest);
        vector.add((Object)this.authorizationResponse);
        vector.add((Object)this.authorizationValidationRequest);
        vector.add((Object)this.authorizationValidationResponse);
        vector.add(this.serverTime);
        vector.add((Object)this.authorizationDownloadRequest);
        vector.add((Object)this.authorizationDownloadResponse);
        return vector;
    }
}

