/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.batc.BATCAuthorizationResponseCode;
import com.xdja.pki.oer.gbt.asn1.Time32;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCInnerATDownloadResponse
extends Sequence {
    private OctetString requestHash;
    private BATCAuthorizationResponseCode responseCode;
    private Time32 certDLTime;
    private OctetString certDLURL;

    public BATCInnerATDownloadResponse() {
        super(false, true);
    }

    public static BATCInnerATDownloadResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List integers = BitByte.setBit((int)integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerATDownloadResponse response = new BATCInnerATDownloadResponse();
        OctetString requestHash = OctetString.getInstance((byte[])data, (int)16);
        data = requestHash.getGoal();
        BATCAuthorizationResponseCode responseCode = BATCAuthorizationResponseCode.getInstance(data);
        data = responseCode.getGoal();
        if (integers.contains(0)) {
            Time32 certDLTime = Time32.getInstance((byte[])data);
            response.setCertDLTime(certDLTime);
            data = certDLTime.getGoal();
        }
        if (integers.contains(1)) {
            OctetString certDLURL = OctetString.getInstance((byte[])data);
            response.setCertDLURL(certDLURL);
            data = certDLURL.getGoal();
        }
        response.setRequestHash(requestHash);
        response.setResponseCode(responseCode);
        response.setGoal(data);
        return response;
    }

    public OctetString getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCAuthorizationResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(BATCAuthorizationResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public Time32 getCertDLTime() {
        return this.certDLTime;
    }

    public void setCertDLTime(Time32 certDLTime) {
        this.certDLTime = certDLTime;
    }

    public OctetString getCertDLURL() {
        return this.certDLURL;
    }

    public void setCertDLURL(OctetString certDLURL) {
        this.certDLURL = certDLURL;
    }

    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.certDLTime != null) {
            optionals.add(7);
        }
        if (this.certDLURL != null) {
            optionals.add(6);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.requestHash);
        vector.add((Object)this.responseCode);
        vector.add(this.certDLTime);
        vector.add(this.certDLURL);
        return vector;
    }
}

