/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.batc.BATCAuthorizationResponseCode;
import com.xdja.pki.oer.batc.BATCCertResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCInnerAtResponse
extends Sequence {
    private OctetString requestHash;
    private BATCAuthorizationResponseCode responseCode;
    private BATCCertResponse certResponse;

    public BATCInnerAtResponse() {
        super(true, true);
    }

    public static BATCInnerAtResponse getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List integers = BitByte.setBit((int)integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerAtResponse innerAtResponse = new BATCInnerAtResponse();
        OctetString requestHash = OctetString.getInstance((byte[])data, (int)16);
        data = requestHash.getGoal();
        BATCAuthorizationResponseCode responseCode = BATCAuthorizationResponseCode.getInstance(data);
        data = responseCode.getGoal();
        if (integers.contains(0)) {
            // empty if block
        }
        if (integers.contains(1)) {
            BATCCertResponse certResponse = BATCCertResponse.getInstance(data);
            data = certResponse.getGoal();
            innerAtResponse.setCertResponse(certResponse);
        }
        innerAtResponse.setRequestHash(requestHash);
        innerAtResponse.setResponseCode(responseCode);
        innerAtResponse.setGoal(data);
        return innerAtResponse;
    }

    public OctetString getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public BATCAuthorizationResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(BATCAuthorizationResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public BATCCertResponse getCertResponse() {
        return this.certResponse;
    }

    public void setCertResponse(BATCCertResponse certResponse) {
        this.certResponse = certResponse;
    }

    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        ArrayList<Integer> optionals = new ArrayList<Integer>();
        if (this.certResponse != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(this.requestHash);
        vector.add((Object)this.responseCode);
        vector.add((Object)this.certResponse);
        return vector;
    }
}

