/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.batc.BATCCertificateFormat;
import com.xdja.pki.oer.batc.BATCCertificateSubjectAttributes;
import com.xdja.pki.oer.batc.BATCPublicKeys;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class BATCInnerEcRequest
extends Sequence {
    private OctetString itsId;
    private BATCCertificateFormat certificateFormat;
    private BATCPublicKeys publicKeys;
    private BATCCertificateSubjectAttributes requestedSubjectAttributes;

    public static BATCInnerEcRequest getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        List integers = BitByte.setBit((int)integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        BATCInnerEcRequest innerEcRequest = new BATCInnerEcRequest();
        OctetString itsId = OctetString.getInstance((byte[])data);
        data = itsId.getGoal();
        BATCCertificateFormat certificateFormat = BATCCertificateFormat.getInstance(data);
        data = certificateFormat.getGoal();
        BATCPublicKeys publicKeys = BATCPublicKeys.getInstance(data);
        data = publicKeys.getGoal();
        BATCCertificateSubjectAttributes requestedSubjectAttributes = BATCCertificateSubjectAttributes.getInstance(data);
        data = requestedSubjectAttributes.getGoal();
        innerEcRequest.setItsId(itsId);
        innerEcRequest.setCertificateFormat(certificateFormat);
        innerEcRequest.setPublicKeys(publicKeys);
        innerEcRequest.setRequestedSubjectAttributes(requestedSubjectAttributes);
        innerEcRequest.setGoal(data);
        return innerEcRequest;
    }

    public BATCInnerEcRequest() {
        super(true, false);
    }

    public OctetString getItsId() {
        return this.itsId;
    }

    public void setItsId(OctetString itsId) {
        this.itsId = itsId;
    }

    public BATCCertificateFormat getCertificateFormat() {
        return this.certificateFormat;
    }

    public void setCertificateFormat(BATCCertificateFormat certificateFormat) {
        this.certificateFormat = certificateFormat;
    }

    public BATCPublicKeys getPublicKeys() {
        return this.publicKeys;
    }

    public void setPublicKeys(BATCPublicKeys publicKeys) {
        this.publicKeys = publicKeys;
    }

    public BATCCertificateSubjectAttributes getRequestedSubjectAttributes() {
        return this.requestedSubjectAttributes;
    }

    public void setRequestedSubjectAttributes(BATCCertificateSubjectAttributes requestedSubjectAttributes) {
        this.requestedSubjectAttributes = requestedSubjectAttributes;
    }

    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.itsId);
        vector.add((Object)this.certificateFormat);
        vector.add((Object)this.publicKeys);
        vector.add((Object)this.requestedSubjectAttributes);
        return vector;
    }
}

