/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc.gccf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import com.xdja.pki.oer.batc.lccf.CertificateStore;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class GlobalCertificateChainFile
extends Sequence {
    private Uint16 version;
    private CertificateStore requiredCerStore;

    public GlobalCertificateChainFile(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public GlobalCertificateChainFile() {
        super(false, false);
    }

    public Uint16 getVersion() {
        return this.version;
    }

    public void setVersion(Uint16 version) {
        this.version = version;
    }

    public CertificateStore getRequiredCerStore() {
        return this.requiredCerStore;
    }

    public void setRequiredCerStore(CertificateStore requiredCerStore) {
        this.requiredCerStore = requiredCerStore;
    }

    public static GlobalCertificateChainFile getInstance(byte[] data) throws Exception {
        GlobalCertificateChainFile globalCertificateChainFile = new GlobalCertificateChainFile();
        byte[] versionBytes = new byte[2];
        System.arraycopy(data, 0, versionBytes, 0, versionBytes.length);
        globalCertificateChainFile.setVersion(new Uint16(BigIntegers.fromUnsignedByteArray((byte[])versionBytes).intValue()));
        CertificateStore certificateStore = CertificateStore.getInstance(GlobalCertificateChainFile.getGoal(data, 2));
        globalCertificateChainFile.setRequiredCerStore(certificateStore);
        globalCertificateChainFile.setGoal(certificateStore.getGoal());
        return globalCertificateChainFile;
    }

    public static byte[] getGoal(byte[] data, int byteNum) {
        byte[] goal = new byte[data.length - byteNum];
        System.arraycopy(data, byteNum, goal, 0, goal.length);
        return goal;
    }

    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.version);
        vector.add((Object)this.requiredCerStore);
        return vector;
    }
}

