/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import com.xdja.pki.oer.batc.lpf.LocalPolicyFile;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class LPFDownLoad
extends Sequence {
    private Uint16 code;
    private LocalPolicyFile fileContent;

    public LPFDownLoad(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LPFDownLoad() {
        super(false, false);
    }

    public static LPFDownLoad getInstance(byte[] data) throws Exception {
        LPFDownLoad lpfDownLoad = new LPFDownLoad();
        byte[] codeBytes = new byte[2];
        System.arraycopy(data, 0, codeBytes, 0, codeBytes.length);
        lpfDownLoad.setCode(new Uint16(BigIntegers.fromUnsignedByteArray((byte[])codeBytes).intValue()));
        byte[] goal = new byte[data.length - codeBytes.length];
        if (goal.length > 0) {
            System.arraycopy(data, 2, goal, 0, goal.length);
            LocalPolicyFile localPolicyFile = LocalPolicyFile.getInstance(goal);
            lpfDownLoad.setFileContent(localPolicyFile);
            lpfDownLoad.setGoal(localPolicyFile.getGoal());
        }
        return lpfDownLoad;
    }

    public Uint16 getCode() {
        return this.code;
    }

    public void setCode(Uint16 code) {
        this.code = code;
    }

    public LocalPolicyFile getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(LocalPolicyFile fileContent) {
        this.fileContent = fileContent;
    }

    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.code);
        vector.add((Object)this.fileContent);
        return vector;
    }
}

