/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.batc.lpf.Policy;
import com.xdja.pki.oer.gbt.asn1.Time64;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class ToBeSignedPolicyData
extends Sequence {
    private OctetString policyID;
    private Time64 generationTime;
    private Policy policy;

    public ToBeSignedPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public ToBeSignedPolicyData() {
        super(false, false);
    }

    public OctetString getPolicyID() {
        return this.policyID;
    }

    public void setPolicyID(OctetString policyID) {
        this.policyID = policyID;
    }

    public Time64 getGenerationTime() {
        return this.generationTime;
    }

    public void setGenerationTime(Time64 generationTime) {
        this.generationTime = generationTime;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public static ToBeSignedPolicyData getInstance(byte[] data) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        OctetString policyID = OctetString.getInstance((byte[])data);
        toBeSignedPolicyData.setPolicyID(policyID);
        byte[] generationTimeBytes = new byte[8];
        System.arraycopy(policyID.getGoal(), 0, generationTimeBytes, 0, generationTimeBytes.length);
        Time64 generationTime = new Time64(BigIntegers.fromUnsignedByteArray((byte[])generationTimeBytes).longValue());
        toBeSignedPolicyData.setGenerationTime(generationTime);
        byte[] goal = new byte[policyID.getGoal().length - 8];
        System.arraycopy(policyID.getGoal(), 8, goal, 0, goal.length);
        Policy policy = Policy.getInstance(goal);
        toBeSignedPolicyData.setPolicy(policy);
        toBeSignedPolicyData.setGoal(policy.getGoal());
        return toBeSignedPolicyData;
    }

    public Vector getSequenceValues() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.policyID);
        vector.add(this.generationTime);
        vector.add((Object)this.policy);
        return vector;
    }
}

