/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.batc.lpf.CustomPolicyData;
import com.xdja.pki.oer.batc.lpf.GlobalPolicyData;
import com.xdja.pki.oer.batc.lpf.LocalPolicyData;
import com.xdja.pki.oer.batc.lpf.Policy;
import com.xdja.pki.oer.batc.lpf.ToBeSignedPolicyData;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.Time64;
import java.io.IOException;
import java.util.UUID;

public class ToBeSignedPolicyDataBuilder {
    public static ToBeSignedPolicyData buildGlobal(GlobalPolicyData globalPolicyData) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        Policy policy = new Policy();
        policy.setGlobal(globalPolicyData);
        OctetString policyId = new OctetString();
        policyId.setString(UUID.randomUUID().toString().getBytes());
        toBeSignedPolicyData.setPolicyID(policyId);
        toBeSignedPolicyData.setPolicy(policy);
        long l = TimeUtils.getNowTime() * 1000L;
        toBeSignedPolicyData.setGenerationTime(new Time64(l));
        return toBeSignedPolicyData;
    }

    public static ToBeSignedPolicyData buildCustom(GlobalPolicyData globalPolicyData, String hostname) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        CustomPolicyData customPolicyData = new CustomPolicyData();
        OctetString octetString = new OctetString();
        octetString.setString(hostname.getBytes());
        customPolicyData.setHostname(octetString);
        customPolicyData.setGlobalPolicy(globalPolicyData);
        OctetString policyId = new OctetString();
        policyId.setString(UUID.randomUUID().toString().getBytes());
        toBeSignedPolicyData.setPolicyID(policyId);
        Policy policy = new Policy();
        policy.setCustom(customPolicyData);
        toBeSignedPolicyData.setPolicy(policy);
        long l = TimeUtils.getNowTime() * 1000L;
        toBeSignedPolicyData.setGenerationTime(new Time64(l));
        return toBeSignedPolicyData;
    }

    public static ToBeSignedPolicyData buildLocal(LocalPolicyData localPolicyData) throws IOException {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        Policy policy = new Policy();
        policy.setLocal(localPolicyData);
        OctetString policyId = new OctetString();
        policyId.setString(UUID.randomUUID().toString().getBytes());
        toBeSignedPolicyData.setPolicyID(policyId);
        toBeSignedPolicyData.setPolicy(policy);
        long l = TimeUtils.getNowTime() * 1000L;
        toBeSignedPolicyData.setGenerationTime(new Time64(l));
        return toBeSignedPolicyData;
    }
}

