package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 *  ATSubjectAttributes ::= SEQUENCE {
 *     assuranceLevel SubjectAssurance OPTIONAL,
 *     itsAidList SequenceOfItsAidList OPTIONAL, ---PSEUDONYM_REGISTRATION_CERTIFICATE_REQUEST = new ItsAid(40965); // 0xa005
 *     itsSspList SequenceOfItsAidSspList OPTIONAL,
 *     ...
 *  }
 */
public class ATSubjectAttributes extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ATSubjectAttributes.class);
    private SubjectAssurance assuranceLevel;
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsSspList;

    public ATSubjectAttributes() {
        super(true, true);
    }

    public static ATSubjectAttributes getInstance(byte[] data) throws Exception {
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        ATSubjectAttributes atSubjectAttributes = new ATSubjectAttributes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (integers.contains(0)) {
            //扩展
        }
        if (integers.contains(1)) {
           // logger.debug("ATSubjectAttributes choice assuranceLevel");
            goal = new byte[1];
            System.arraycopy(data, 0, goal, 0, goal.length);
            SubjectAssurance assuranceLevel = new SubjectAssurance(goal);
            atSubjectAttributes.setAssuranceLevel(assuranceLevel);
            goal = new byte[data.length - 1];
            System.arraycopy(data, 1, goal, 0, goal.length);
            data = goal;
        }
        if (integers.contains(2)) {
            //logger.debug("ATSubjectAttributes choice itsAidList");
            SequenceOfItsAidList instance = SequenceOfItsAidList.getInstance(data);
            atSubjectAttributes.setItsAidList(instance);
            data = instance.getGoal();
        }
        if (integers.contains(3)) {
           // logger.debug("ATSubjectAttributes choice itsSspList");
            SequenceOfItsAidSspList instance = SequenceOfItsAidSspList.getInstance(data);
            atSubjectAttributes.setItsSspList(instance);
            data = instance.getGoal();
        }
        atSubjectAttributes.setGoal(data);
        return atSubjectAttributes;
    }

    public SubjectAssurance getAssuranceLevel() {
        return assuranceLevel;
    }

    public void setAssuranceLevel(SubjectAssurance assuranceLevel) {
        this.assuranceLevel = assuranceLevel;
    }

    public SequenceOfItsAidList getItsAidList() {
        return itsAidList;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public SequenceOfItsAidSspList getItsSspList() {
        return itsSspList;
    }

    public void setItsSspList(SequenceOfItsAidSspList itsSspList) {
        this.itsSspList = itsSspList;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.assuranceLevel != null) {
            optionals.add(7);
        }
        if (this.itsAidList != null) {
            optionals.add(6);
        }
        if (this.itsSspList != null) {
            optionals.add(5);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(assuranceLevel);
        vector.add(itsAidList);
        vector.add(itsSspList);
        return vector;
    }
}
