package com.xdja.pki.oer.gbt.asn1;




import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 *ATTbsCert ::= SEQUENCE {
 *     subjectInfo             SubjectInfo,
 *     subjectAttributes       ATSubjectAttributes,
 *     validityRestrictions    ValidityRestriction
 * }
 */
public class ATTbsCert extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ATTbsCert.class);
    private SubjectInfo subjectInfo;
    private ATSubjectAttributes subjectAttributes;
    private ValidityRestriction validityRestrictions;

    public ATTbsCert() {
        super(false, false);
    }

    public static ATTbsCert getInstance(byte[] data) throws Exception {
        ATTbsCert atTbsCert = new ATTbsCert();

        SubjectInfo subjectInfo = SubjectInfo.getInstance(data);

        atTbsCert.setSubjectInfo(subjectInfo);
        data = subjectInfo.getGoal();
        ATSubjectAttributes subjectAttributes = ATSubjectAttributes.getInstance(data);

        atTbsCert.setSubjectAttributes(subjectAttributes);
        data = subjectAttributes.getGoal();
        ValidityRestriction validityRestriction = ValidityRestriction.getInstance(data);

        atTbsCert.setValidityRestrictions(validityRestriction);
        data = validityRestriction.getGoal();

        atTbsCert.setGoal(data);
        return atTbsCert;
    }


    public SubjectInfo getSubjectInfo() {
        return subjectInfo;
    }

    public void setSubjectInfo(SubjectInfo subjectInfo) {
        this.subjectInfo = subjectInfo;
    }

    public ATSubjectAttributes getSubjectAttributes() {
        return subjectAttributes;
    }

    public void setSubjectAttributes(ATSubjectAttributes subjectAttributes) {
        this.subjectAttributes = subjectAttributes;
    }

    public ValidityRestriction getValidityRestrictions() {
        return validityRestrictions;
    }

    public void setValidityRestrictions(ValidityRestriction validityRestrictions) {
        this.validityRestrictions = validityRestrictions;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(subjectInfo);
        vector.add(subjectAttributes);
        vector.add(validityRestrictions);
        return vector;
    }
}
