package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/**
 * AesCcmCipherText ::= SEQUENCE{
 * nonce   OCTET STRING(SIZE(12)),
 * cipher  CipherText
 * }
 */
public class AesCcmCipherText extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(AesCcmCipherText.class);

    private OctetString nonce;
    private CipherText cipher;

    public AesCcmCipherText() {
        super(false, false);
    }

    public static AesCcmCipherText getInstance(byte[] data) throws Exception {
        OctetString nonce = new OctetString();
        byte[] goal = new byte[12];
        System.arraycopy(data, 0, goal, 0, goal.length);
        nonce.setString(goal);
        nonce.setLength(12);

        goal = new byte[data.length - 12];
        System.arraycopy(data, 12, goal, 0, goal.length);
        data = goal;
        OctetString octetString = OctetString.getInstance(data);
        CipherText cipherText = new CipherText();
        cipherText.setString(octetString.getString());

        data = octetString.getGoal();
        AesCcmCipherText aesCcmCipherText = new AesCcmCipherText();
        aesCcmCipherText.setCipher(cipherText);
        aesCcmCipherText.setNonce(nonce);
        aesCcmCipherText.setGoal(data);
        return aesCcmCipherText;
    }

    public void setNonce(OctetString nonce) {
        this.nonce = nonce;
    }

    public void setCipher(CipherText cipher) {
        this.cipher = cipher;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = new OctetString();
        this.nonce.setLength(12);
        this.nonce.setString(nonce);
    }

    public OctetString getNonce() {
        return nonce;
    }

    public CipherText getCipher() {
        return cipher;
    }


    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(nonce);
        vector.add(cipher);
        return vector;
    }
}
