package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 * AuthorizationValidationRequest := SEQUENCE{
 *     sharedATRequest SharedATRequest, ---为 “obu-pca 中 SharedATRequest”
 *     ecSignature EcSignature  ---为 “obu-pca 中 3.ECA加密身份验证消息体”
 * }
 */
public class AuthorizationValidationRequest extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(AuthorizationValidationResponse.class);

    private SharedATRequest sharedATRequest;
    private EcSignature ecSignature;

    public AuthorizationValidationRequest() {
        super(false, false);
    }

    public AuthorizationValidationRequest(SharedATRequest sharedATRequest, EcSignature ecSignature) {
        super(false, false);
        this.sharedATRequest = sharedATRequest;
        this.ecSignature = ecSignature;
    }

    public static AuthorizationValidationRequest getInstanse(byte[] data) throws Exception {

        SharedATRequest sharedATRequest = SharedATRequest.getInstance(data);
        byte[] goal = sharedATRequest.getGoal();

        EcSignature ecSignature = EcSignature.getInstance(goal);
        AuthorizationValidationRequest authorizationValidationRequest = new AuthorizationValidationRequest(sharedATRequest, ecSignature);

        authorizationValidationRequest.setGoal(ecSignature.getGoal());

        return authorizationValidationRequest;
    }

    public SharedATRequest getSharedATRequest() {
        return sharedATRequest;
    }

    public void setSharedATRequest(SharedATRequest sharedATRequest) {
        this.sharedATRequest = sharedATRequest;
    }

    public EcSignature getEcSignature() {
        return ecSignature;
    }

    public void setEcSignature(EcSignature ecSignature) {
        this.ecSignature = ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(sharedATRequest);
        vector.add(ecSignature);
        return vector;
    }
}
