package com.xdja.pki.oer.gbt.asn1;

/***
 * --- 1. AuthorizationValidationRequestEnc
 * AuthorizationValidationRequestEnc := SecuredMessage
 * SecuredMessage ::= SEQUENCE{
 *     version  Uint8,
 *     payload  Payload
 * }
 * Payload ::= CHOICE{
 *     unSecuredData   Opaque,
 *     signedData      SignedData,
 *     encData         EncryptedData ---选择这个
 * }
 * EncryptedData ::= SEQUENCE{
 *     recipients  SequenceOfRecipientInfo, ---ECA证书公钥加密 对称密钥
 *     cipherText  SymmetricCipherText ---对称密钥加密 “2. 请求数据” 密文
 * }
 * --- ECA证书 公钥加密 对称密钥
 * RecipientInfo ::=  CHOICE{
 *     pskRecipientInfo    PreSharedKeyRecipientInfo,
 *     symmRecipInfo       SymmRecipInfo,
 *     certRecipInfo       PKRecipientInfo,
 *     signedDataRecipInfo PKRecipientInfo
 * };
 * SymmetricCipherText ::= CHOICE {
 *     sm4Ecb  CipherText, ---sm4ecb 选择这个
 *     sm4Cbc  SM4CipherText,
 *     sm4Cfb  SM4CipherText,
 *     sm4Ofb  SM4CipherText,
 *     aesCcm  AesCcmCipherText
 * }
 * CipherText  ::= Opaque ---Opaque结构 OctetString
 */
public class AuthorizationValidationRequestEnc extends SecuredMessage {

    public static AuthorizationValidationRequestEnc getInstance(byte[] data) throws Exception {
        SecuredMessage securedMessage = SecuredMessage.getInstance(data);
        AuthorizationValidationRequestEnc enc = new AuthorizationValidationRequestEnc();
        enc.setVersion(securedMessage.getVersion());
        enc.setPayload(securedMessage.getPayload());
        return enc;
    }

}
