package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 * -- 6.2.2.1 证书结构 国际 CertificateBase 不同
 * <p>
 * Certificate ::= SEQUENCE {
 * version     Uint8,
 * issuerId    IssuerId,
 * tbs         TbsCert,
 * signature   Signature
 * }
 * <p>
 * TbsCert ::= SEQUENCE {
 * subjectInfo             SubjectInfo,
 * subjectAttributes       SubjectAttributes,
 * validityRestrictions    ValidityRestriction
 * }
 */
public class Certificate extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(Certificate.class);
    private IssuerId issuerId;
    private TbsCert tbsCert;
    private Signature signature;
    private int version;

    public Certificate() {
        super(false, false);
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static Certificate getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "Certificate start data", data);
        Certificate certificate = new Certificate();
        //去verison
        certificate.setVersion(BigIntegers.fromUnsignedByteArray(data, 0, 1).intValue());
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        IssuerId issuerId = IssuerId.getInstance(data);
        data = issuerId.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "Certificate IssuerId data", issuerId.getEncode());
        TbsCert tbsCert = TbsCert.getInstance(data);
        data = tbsCert.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "Certificate tbsCert data", tbsCert.getEncode());
        Signature signature = Signature.getInstance(data);
        data = signature.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "Certificate signature data", signature.getEncode());

        certificate.setIssuerId(issuerId);
        certificate.setSignature(signature);
        certificate.setTbsCert(tbsCert);
        certificate.setGoal(data);
        //ByteArrayUtils.printHexBinary(logger, "Certificate lave data", data);
        return certificate;
    }

    public IssuerId getIssuerId() {
        return issuerId;
    }

    public void setIssuerId(IssuerId issuerId) {
        this.issuerId = issuerId;
    }

    public TbsCert getTbsCert() {
        return tbsCert;
    }

    public void setTbsCert(TbsCert tbsCert) {
        this.tbsCert = tbsCert;
    }

    public Signature getSignature() {
        return signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(2);
        vector.add(issuerId);
        vector.add(tbsCert);
        vector.add(signature);
        return vector;
    }
}
