package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/***
 * HashedId8 ::= OCTET STRING (SIZE (8))
 */
public class HashedId10 extends OctetString {
    private static Logger logger = LoggerFactory.getLogger(HashedId10.class);

    public HashedId10(byte[] string) throws IOException {
        this.setLength(10);
        this.setString(string);
    }

    public static HashedId10 getInstance(byte[] data) throws Exception {
        byte[] goal = new byte[10];
        System.arraycopy(data, 0, goal, 0, goal.length);
        HashedId10 hashedId10 = new HashedId10(goal);
        goal = new byte[data.length - 10];
        System.arraycopy(data, 10, goal, 0, goal.length);
        hashedId10.setGoal(goal);
        return hashedId10;
    }
}
