package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.OctetString;

/**
 * HashedId3 ::= OCTET STRING (SIZE (3))
 *
 * 说明：本 哈希值 用来识别证书等数据，首先计算输入数据的哈希值，然后从哈希值中取 3个最低 有效字节，
 * 最低的3个字节是 32 字节的 散列的 最后3个字节
 */
public class HashedId3 extends OctetString {
    public HashedId3(byte[] string) {
        this.setLength(3);
        this.setString(string);
    }
}
