package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/***
 *InnerATRequest := SEQUENCE{
 *     verificationKey PublicVerifyKey,
 *     encryptionKey PublicEncryptionKey Optional, -- （暂时不启用，如果对完结构体有时间周二之前处理，如果没时间一期之前处理）
 *     sharedATRequest SharedATRequest,
 *     ecSignature EcSignature  ---为 “3.ECA加密身份验证消息体”
 * }
 *
 */
public class InnerATRequest extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(InnerATRequest.class);
    private PublicVerifyKey verificationKey;
    private PublicEncryptionKey encryptionKey;
    private SharedATRequest sharedATRequest;
    private EcSignature ecSignature;

    public InnerATRequest() {
        super(false, true);
    }

    public static InnerATRequest getInstance(byte[] data) throws Exception {

        InnerATRequest innerATRequest = new InnerATRequest();
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(integer.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        PublicVerifyKey verifyKey = PublicVerifyKey.getInstance(data);
        data = verifyKey.getGoal();
        innerATRequest.setVerificationKey(verifyKey);
        if (integers.contains(0)) {
            PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
            data = encryptionKey.getGoal();
            innerATRequest.setEncryptionKey(encryptionKey);
        }
        SharedATRequest sharedATRequest = SharedATRequest.getInstance(data);
        //ByteArrayUtils.printHexBinary(logger, "innerATRequest sharedATRequest data", sharedATRequest.getEncode());
        data = sharedATRequest.getGoal();
        innerATRequest.setSharedATRequest(sharedATRequest);
        EcSignature ecSignature = EcSignature.getInstance(data);
        innerATRequest.setEcSignature(ecSignature);
        //ByteArrayUtils.printHexBinary(logger, "innerATRequest setEcSignature data", sharedATRequest.getEncode());
        data = ecSignature.getGoal();
        innerATRequest.setGoal(data);
        //ByteArrayUtils.printHexBinary(logger, "innerATRequest lave data", data);
        return innerATRequest;
    }

    public PublicVerifyKey getVerificationKey() {
        return verificationKey;
    }

    public void setVerificationKey(PublicVerifyKey verificationKey) {
        this.verificationKey = verificationKey;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return encryptionKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public SharedATRequest getSharedATRequest() {
        return sharedATRequest;
    }

    public void setSharedATRequest(SharedATRequest sharedATRequest) {
        this.sharedATRequest = sharedATRequest;
    }

    public EcSignature getEcSignature() {
        return ecSignature;
    }

    public void setEcSignature(EcSignature ecSignature) {
        this.ecSignature = ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        List<Integer> optionals = new ArrayList<>();
        if (this.encryptionKey != null) {
            optionals.add(7);
        }
        if (optionals.size() > 0) {
            this.addOptional(optionals);
        }
        vector.add(verificationKey);
        vector.add(encryptionKey);
        vector.add(sharedATRequest);
        vector.add(ecSignature);
        return vector;
    }
}
