package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 * -- 6.2.1.8 加密公钥 国际 PublicEncryptionKey 没有 eccCurve
 *
 * PublicEncryptionKey ::= SEQUENCE {
 *     supportedSymmAlg  SymmAlgorithm,// 应该是 SymmetricAlgorithm 国际上是 SymmAlgorithm
 *     eccCurve          EccCurve,
 *     publicKey         ECCPoint
 * }
 *
 */
public class PublicEncryptionKey extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PublicEncryptionKey.class);
    private SymmetricAlgorithm supportedSymmAlg;
    private EccCurve eccCurve;
    private EccPoint publicKey;

    public PublicEncryptionKey() {
        super(false, false);
    }

    public static PublicEncryptionKey getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey start data", data);
        SymmetricAlgorithm supportedSymmAlg = SymmetricAlgorithm.getInstance(data);
        data = supportedSymmAlg.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey supportedSymmAlg data", supportedSymmAlg.getEncode());
        EccCurve eccCurve = EccCurve.getInstance(data);
        data = eccCurve.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey eccCurve data", eccCurve.getEncode());
        EccPoint eccPoint = EccPoint.getInstance(data);
        data = eccPoint.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey eccPoint data", eccPoint.getEncode());
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setSupportedSymmAlg(supportedSymmAlg);
        publicEncryptionKey.setPublicKey(eccPoint);
        publicEncryptionKey.setEccCurve(eccCurve);
        publicEncryptionKey.setGoal(data);
        //ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey lave data", publicEncryptionKey.getGoal());
        return publicEncryptionKey;
    }

    public void setSupportedSymmAlg(SymmetricAlgorithm supportedSymmAlg) {
        this.supportedSymmAlg = supportedSymmAlg;
    }

    public void setEccCurve(EccCurve eccCurve) {
        this.eccCurve = eccCurve;
    }

    public void setPublicKey(EccPoint publicKey) {
        this.publicKey = publicKey;
    }

    public SymmetricAlgorithm getSupportedSymmAlg() {
        return supportedSymmAlg;
    }

    public EccCurve getEccCurve() {
        return eccCurve;
    }

    public EccPoint getPublicKey() {
        return publicKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(supportedSymmAlg);
        vector.add(eccCurve);
        vector.add(publicKey);
        return vector;
    }
}
