package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 *
 * -- 6.2.1.12 矩形区域
 *
 * RectangularRegion ::= SEQUENCE {
 *     northWest  TwoDLocation,
 *     southEast  TwoDLocation
 * }
 *
 */
public class RectangularRegion extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(RectangularRegion.class);
    private TwoDLocation northWest;
    private TwoDLocation southEast;

    public RectangularRegion() {
        super(false, false);
    }

    public TwoDLocation getNorthWest() {
        return northWest;
    }

    public void setNorthWest(TwoDLocation northWest) {
        this.northWest = northWest;
    }

    public TwoDLocation getSouthEast() {
        return southEast;
    }

    public void setSouthEast(TwoDLocation southEast) {
        this.southEast = southEast;
    }

    public static RectangularRegion getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "RectangularRegion start data", data);
        RectangularRegion rectangularRegion = new RectangularRegion();
        TwoDLocation northWest = TwoDLocation.getInstance(data);
        //ByteArrayUtils.printHexBinary(logger, "RectangularRegion northWest data", northWest.getEncode());
        data = northWest.getGoal();
        TwoDLocation southEast = TwoDLocation.getInstance(data);
        //ByteArrayUtils.printHexBinary(logger, "RectangularRegion southEast data", southEast.getEncode());
        rectangularRegion.setNorthWest(northWest);
        rectangularRegion.setSouthEast(southEast);
        rectangularRegion.setGoal(southEast.getGoal());
        //ByteArrayUtils.printHexBinary(logger, "RectangularRegion lave data", southEast.getEncode());
        return rectangularRegion;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(northWest);
        vector.add(southEast);
        return vector;
    }
}
