package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/**
 * -- 6.3 合作式ITS安全消息语法
 * -- 6.3.1  安全消息
 * --  version: 安全消息语法版本当前为2
 * --  payload： 消息载荷
 * SecuredMessage ::= SEQUENCE{
 * version  Uint8,
 * payload  Payload
 * }
 */
public class SecuredMessage extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SecuredMessage.class);
    private Payload payload;
    private int version;

    public SecuredMessage() {
        super(false, false);
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Payload getPayload() {
        return payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public static SecuredMessage getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SecuredMessage start data", data);
        SecuredMessage securedMessage = new SecuredMessage();
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        securedMessage.setVersion(integer.intValue());
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        Payload payload = Payload.getInstance(goal);
        securedMessage.setPayload(payload);
        //ByteArrayUtils.printHexBinary(logger, "SecuredMessage payload data", payload.getEncode());
        securedMessage.setGoal(payload.getGoal());
        //ByteArrayUtils.printHexBinary(logger, "SecuredMessage lave data", securedMessage.getGoal());
        return securedMessage;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        //version
        vector.add(2);
        vector.add(payload);
        return vector;
    }
}
