package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.SequenceOf;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class SequenceOfCertificate extends SequenceOf {
    private static Logger logger = LoggerFactory.getLogger(SequenceOfCertificate.class);

    private List<Certificate> certificates = new ArrayList<>();

    public List<Certificate> getCertificates() {
        return certificates;
    }

    public void setCertificates(Certificate certificates) {
        this.certificates.add(certificates);
    }

    public void addCertificate(Certificate certificate) {
        super.addOERObject(certificate);
    }

    public static SequenceOfCertificate getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SequenceOfCertificate start data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 1, len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        for (int i = 0; i < length.intValue(); i++) {
            Certificate instance = Certificate.getInstance(goal);
            sequenceOfCertificate.setCertificates(instance);
            goal = instance.getGoal();
            sequenceOfCertificate.addCertificate(instance);
            //ByteArrayUtils.printHexBinary(logger, "SequenceOfCertificate  at index " + i + " Certificate data ", instance.getEncode());
        }
        sequenceOfCertificate.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "SequenceOfCertificate lave data ", goal);
        return sequenceOfCertificate;
    }

}
