package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.SequenceOf;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/***
 *
 * SequenceOfItsAidList ::= SEQUENCE OF ItsAid
 *
 */
public class SequenceOfItsAidList extends SequenceOf {

    private static Logger logger = LoggerFactory.getLogger(SequenceOfItsAidList.class);

    private List<ItsAid> itsAids = new ArrayList<>();

    public List<ItsAid> getItsAid() {
        return itsAids;
    }

    public void setItsAid(ItsAid itsAid) {
        this.itsAids.add(itsAid);
    }

    public void addItsAid(ItsAid itsAid) {
        super.addOERObject(itsAid);
    }

    public static SequenceOfItsAidList getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SequenceOfItsAidList start data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 1, len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        SequenceOfItsAidList sequenceOfItsAidList = new SequenceOfItsAidList();
        for (int i = 0; i < length.intValue(); i++) {
            ItsAid instance = ItsAid.getInstance(goal);
            goal = instance.getGoal();
            sequenceOfItsAidList.addItsAid(instance);
            sequenceOfItsAidList.setItsAid(instance);
            //ByteArrayUtils.printHexBinary(logger, "SequenceOfItsAidList  at index" + i + "ItsAid data ", instance.getEncode());
        }
        sequenceOfItsAidList.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "SequenceOfItsAidList lave data ", goal);
        return sequenceOfItsAidList;
    }
}
