package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.SequenceOf;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/***
 *
 * SequenceOfitsAidSspList ::= SEQUENCE OF ItsAidSsp
 *
 */
public class SequenceOfItsAidSspList extends SequenceOf {
    private static Logger logger = LoggerFactory.getLogger(SequenceOfItsAidSspList.class);

    private List<ItsAidSsp> itsAidSsps = new ArrayList<>();

    public List<ItsAidSsp> getItsAidSsp() {
        return itsAidSsps;
    }

    public void setItsAidSsp(ItsAidSsp itsAidSsp) {
        this.itsAidSsps.add(itsAidSsp);
    }


    public void addItsAidSsp(ItsAidSsp itsAidSsp) {
        super.addOERObject(itsAidSsp);
    }

    public static SequenceOfItsAidSspList getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SequenceOfItsAidSspList start data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        BigInteger length = BigIntegers.fromUnsignedByteArray(data, 1, len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        SequenceOfItsAidSspList sequenceOfItsAidSspList = new SequenceOfItsAidSspList();
        for (int i = 0; i < length.intValue(); i++) {
            ItsAidSsp instance = ItsAidSsp.getInstance(goal);
            goal = instance.getGoal();
            sequenceOfItsAidSspList.addItsAidSsp(instance);
            sequenceOfItsAidSspList.setItsAidSsp(instance);
            //ByteArrayUtils.printHexBinary(logger, "SequenceOfItsAidSspList  at index" + i + "ItsAidSsp data ", instance.getEncode());
        }
        sequenceOfItsAidSspList.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "SequenceOfItsAidSspList lave  data ", goal);
        return sequenceOfItsAidSspList;
    }
}
