package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 SharedATRequest ::= SEQUENCE{
 version Uint8,
 currentTime Time32,  ---当前时间？
 tbsCert ATTbsCert,
 encryptionKey PublicEncryptionKey ---临时加密公钥 需要在 response 中加密 对称密钥
 }
 */
public class SharedATRequest extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SharedATRequest.class);
    private Time32 currentTime;
    private ATTbsCert tbsCert;
    private PublicEncryptionKey encryptionKey;


    public SharedATRequest() {
        super(false, false);
    }

    public static SharedATRequest getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SharedATRequest start data", data);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        Time32 time32 = Time32.getInstance(data);
        SharedATRequest sharedATRequest = new SharedATRequest();
        sharedATRequest.setCurrentTime(time32);
        data = time32.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "SharedATRequest time32 data", time32.getEncode());
        ATTbsCert atTbsCert = ATTbsCert.getInstance(data);
        sharedATRequest.setTbsCert(atTbsCert);
        data = atTbsCert.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "SharedATRequest atTbsCert data", atTbsCert.getEncode());
        PublicEncryptionKey encryptionKey = PublicEncryptionKey.getInstance(data);
        sharedATRequest.setEncryptionKey(encryptionKey);
        //ByteArrayUtils.printHexBinary(logger, "SharedATRequest encryptionKey data", encryptionKey.getEncode());
        data = encryptionKey.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "SharedATRequest lave data", data);
        sharedATRequest.setGoal(data);
        return sharedATRequest;
    }

    public Time32 getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(Time32 currentTime) {
        this.currentTime = currentTime;
    }

    public ATTbsCert getTbsCert() {
        return tbsCert;
    }

    public void setTbsCert(ATTbsCert tbsCert) {
        this.tbsCert = tbsCert;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return encryptionKey;
    }

    public void setEncryptionKey(PublicEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(2);
        vector.add(currentTime);
        vector.add(tbsCert);
        vector.add(encryptionKey);
        return vector;
    }
}
