package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/**
 * --  signer  签名者标识
 * --  tbs     待签名数据
 * --  sign    对tbs签名的结果
 * SignedData ::= SEQUENCE{
 * signer  SignerInfo,
 * tbs     TBSData,
 * sign    Signature
 * }
 */
public class SignedData extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SignedData.class);
    private SignerInfo signerInfo;
    private TBSData tbs;
    private Signature sign;

    public SignedData() {
        super(false, false);
    }

    public static SignedData getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SignedData start data ", data);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        SignedData signedData = new SignedData();
        SignerInfo signerInfo = SignerInfo.getInstance(data);
        //ByteArrayUtils.printHexBinary(logger, "SignedData signerInfo data ", signerInfo.getEncode());
        signedData.setSignerInfo(signerInfo);
        data = signerInfo.getGoal();
        TBSData tbsData = TBSData.getInstance(data);
        signedData.setTbs(tbsData);
        data = tbsData.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "TBSData data ", tbsData.getEncode());
        Signature signature = Signature.getInstance(data);
        signedData.setSign(signature);
        signedData.setGoal(signature.getGoal());
        return signedData;
    }

    public void setSignerInfo(SignerInfo signerInfo) {
        this.signerInfo = signerInfo;
    }

    public void setTbs(TBSData tbs) {
        this.tbs = tbs;
    }

    public void setSign(Signature sign) {
        this.sign = sign;
    }

    public SignerInfo getSignerInfo() {
        return signerInfo;
    }

    public TBSData getTbs() {
        return tbs;
    }

    public Signature getSign() {
        return sign;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(signerInfo);
        vector.add(tbs);
        vector.add(sign);
        return vector;
    }
}
