package com.xdja.pki.oer.gbt.asn1;

import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/**
 * -- 说明 hashAlg 用于计算recipientId的摘要算法
 * -- recipientId 用于解密encKey的对称密钥的摘要
 * -- encKey       用于数据加密的对称密钥，被其他对称密钥加密过的密文
 * SymmRecipInfo ::= SEQUENCE{
 * hashAlg     HashAlgorithm,
 * recipientId HashedId8,
 * encKey      SymmetricCipherText
 * };
 */
public class SymmRecipInfo extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(SymmRecipInfo.class);
    private HashAlgorithm hashAlg;
    private HashedId8 recipientId;
    private SymmetricCipherText encKey;

    public SymmRecipInfo() {
        super(false, false);
    }

    public static SymmRecipInfo getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo start data", data);
        HashAlgorithm hashAlgorithm = HashAlgorithm.getInstance(data);
        SymmRecipInfo symmRecipInfo = new SymmRecipInfo();
        symmRecipInfo.setHashAlg(hashAlgorithm);
        data = hashAlgorithm.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo hashAlg data", hashAlgorithm.getEncode());
        HashedId8 hashedId8 = HashedId8.getInstance(data);
        symmRecipInfo.setRecipientId(hashedId8);
        data = hashedId8.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo recipientId data", hashedId8.getEncode());
        SymmetricCipherText encKey = SymmetricCipherText.getInstance(data);
        symmRecipInfo.setEncKey(encKey);
        symmRecipInfo.setGoal(encKey.getGoal());
        //ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo encKey data", encKey.getEncode());
        //ByteArrayUtils.printHexBinary(logger, "SymmRecipInfo lave data", symmRecipInfo.getGoal());
        return symmRecipInfo;
    }

    public void setHashAlg(HashAlgorithm hashAlg) {
        this.hashAlg = hashAlg;
    }

    public void setRecipientId(HashedId8 recipientId) {
        this.recipientId = recipientId;
    }

    public void setEncKey(SymmetricCipherText encKey) {
        this.encKey = encKey;
    }

    public HashAlgorithm getHashAlg() {
        return hashAlg;
    }

    public HashedId8 getRecipientId() {
        return recipientId;
    }

    public SymmetricCipherText getEncKey() {
        return encKey;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(hashAlg);
        vector.add(recipientId);
        vector.add(encKey);
        return vector;
    }
}
