package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Uint32;
import com.xdja.pki.oer.core.TimeUtils;
import org.bouncycastle.util.BigIntegers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

/***
 * Time32 ::= Uint32
 */
public class Time32 extends Uint32 {
    public BigInteger time;

    public Time32(long i) throws IOException {
        super(i);
    }

    public static Time32 getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "Time32 start data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 4);
        Time32 time32 = new Time32(integer.longValue());
        byte[] goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);
        time32.time = integer;
        time32.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "Time32 lave data", time32.getGoal());
        return time32;
    }

    public BigInteger getTime() {
        return this.time;
    }

    public Date getDate() throws IOException {
        long l = this.time.longValue();
        return TimeUtils.getTimeFromNumber(l);
    }
}
