package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Uint64;
import com.xdja.pki.oer.core.TimeUtils;
import org.bouncycastle.util.BigIntegers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

/**
 * --  6.2.14 64为时间
 * --  64位无符号整数，高位优先编码格式，自2004年1月1日UTC00：00：00开始，给出国际原子时间的秒数
 * Time64 : Uint64
 */
public class Time64 extends Uint64 {
    private BigInteger time;

    public Time64(long l) throws IOException {
        super(l);
    }

    public static Time64 getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "Time64 start data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 8);
        Time64 time64 = new Time64(integer.longValue());
        time64.time = integer;
        byte[] goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        time64.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "Time64 lave data", time64.getGoal());
        return time64;
    }

    public BigInteger getTime(){
        return this.time;
    }

    public Date getDate() throws IOException {
        long l = this.time.longValue();
        return TimeUtils.getTimeFromNumber(l/1000);
    }
}
