package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

/***
 * TimeStartAndEnd ::= SEQUENCE {
 *     startValidity     Time32,
 *     endValidity     Time32
 * }
 *
 */
public class TimeStartAndEnd extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(TimeStartAndEnd.class);
    private Time32 startValidity;
    private Time32 endValidity;

    //    public TimeStartAndEnd(long start, long end) throws IOException {
//        super(false);
//        Time32 st = new Time32(start);
//        Time32 et = new Time32(end);
//        this.write(st.getEncode());
//        this.write(et.getEncode());
//    }
    public static TimeStartAndEnd getInstance(byte[] data) throws IOException {
        //ByteArrayUtils.printHexBinary(logger, "TimeStartAndEnd start data ", data);
        TimeStartAndEnd timeStartAndEnd = new TimeStartAndEnd();
        BigInteger startValidity = BigIntegers.fromUnsignedByteArray(data, 0, 4);
        timeStartAndEnd.setStartValidity(new Time32(startValidity.longValue()));
        //ByteArrayUtils.printHexBinary(logger, "TimeStartAndEnd startValidity data ", timeStartAndEnd.getStartValidity().getEncode());
        BigInteger endValidity = BigIntegers.fromUnsignedByteArray(data, 4, 4);
        timeStartAndEnd.setEndValidity(new Time32(endValidity.longValue()));
        //ByteArrayUtils.printHexBinary(logger, "TimeStartAndEnd startValidity data ", timeStartAndEnd.getEndValidity().getEncode());
        byte[] goal = new byte[data.length - 8];
        System.arraycopy(data, 8, goal, 0, goal.length);
        timeStartAndEnd.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "TimeStartAndEnd startValidity data ", timeStartAndEnd.getGoal());
        return timeStartAndEnd;
    }

    public TimeStartAndEnd() {
        super(false, false);
    }

    public Time32 getStartValidity() {
        return startValidity;
    }

    public void setStartValidity(Time32 startValidity) {
        this.startValidity = startValidity;
    }

    public Time32 getEndValidity() {
        return endValidity;
    }

    public void setEndValidity(Time32 endValidity) {
        this.endValidity = endValidity;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(startValidity);
        vector.add(endValidity);
        return vector;
    }
}
