package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 *
 * ToBeSignedCrl ::= SEQUENCE {
 *     crlSerial Uint32,
 *     issueDate Time32,
 *     nextCrl Time32,
 *     entries SequenceOfRevokeInfo
 * }
 *
 */

public class ToBeSignedCrl extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ToBeSignedCrl.class);
    private Uint32 crlSerial;
    private Time32 issueDate;
    private Time32 nextCrl;
    private SequenceOfRevokeInfo entries;

    public static ToBeSignedCrl getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "ToBeSignedCrl start data", data);
        Uint32 crlSerial = Uint32.getInstance(data);
        data = crlSerial.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "ToBeSignedCrl crlSerial data", crlSerial.getEncode());
        Time32 issueDate = Time32.getInstance(data);
        data = issueDate.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "ToBeSignedCrl issueDate data", issueDate.getEncode());
        Time32 nextCrl = Time32.getInstance(data);
        data = nextCrl.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "ToBeSignedCrl nextCrl data", nextCrl.getEncode());
        SequenceOfRevokeInfo entries = SequenceOfRevokeInfo.getInstance(data);
        data = entries.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "ToBeSignedCrl lave data", data);
        ToBeSignedCrl toBeSignedCrl = new ToBeSignedCrl();
        toBeSignedCrl.setCrlSerial(crlSerial);
        toBeSignedCrl.setEntries(entries);
        toBeSignedCrl.setIssueDate(issueDate);
        toBeSignedCrl.setNextCrl(nextCrl);
        toBeSignedCrl.setGoal(data);
        return toBeSignedCrl;

    }
    public ToBeSignedCrl() {
        super(false, false);
    }

    public Uint32 getCrlSerial() {
        return crlSerial;
    }

    public void setCrlSerial(Uint32 crlSerial) {
        this.crlSerial = crlSerial;
    }

    public Time32 getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Time32 issueDate) {
        this.issueDate = issueDate;
    }

    public Time32 getNextCrl() {
        return nextCrl;
    }

    public void setNextCrl(Time32 nextCrl) {
        this.nextCrl = nextCrl;
    }

    public SequenceOfRevokeInfo getEntries() {
        return entries;
    }

    public void setEntries(SequenceOfRevokeInfo entries) {
        this.entries = entries;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(crlSerial);
        vector.add(issueDate);
        vector.add(nextCrl);
        vector.add(entries);
        return vector;
    }
}
