package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.Int;
import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 *
 * -- 6.2.1.14 二维位置信息
 *
 * TwoDLocation ::= SEQUENCE {
 *     latitude   Latitude,
 *     longitude  Longitude
 * }
 *
 */
public class TwoDLocation extends Sequence {

    private static Logger logger = LoggerFactory.getLogger(TwoDLocation.class);

    private Latitude latitude;
    private Longitude longitude;

    public TwoDLocation() {
        super(false, false);
    }

    public static TwoDLocation getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "TwoDLocation start data", data);
        Int anInt = Latitude.getInstance(data, 4);
        Latitude latitude = new Latitude(anInt.getValue());
        //ByteArrayUtils.printHexBinary(logger, "TwoDLocation Latitude ", latitude.getEncode());
        data = anInt.getGoal();

        anInt = Longitude.getInstance(data, 4);
        Longitude longitude = new Longitude(anInt.getValue());
        //ByteArrayUtils.printHexBinary(logger, "TwoDLocation longitude ", longitude.getEncode());
        data = anInt.getGoal();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(longitude);
        twoDLocation.setLatitude(latitude);
        twoDLocation.setGoal(data);
        //ByteArrayUtils.printHexBinary(logger, "TwoDLocation lave data", data);
        return twoDLocation;
    }

    public Latitude getLatitude() {
        return latitude;
    }

    public void setLatitude(Latitude latitude) {
        this.latitude = latitude;
    }

    public Longitude getLongitude() {
        return longitude;
    }

    public void setLongitude(Longitude longitude) {
        this.longitude = longitude;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(latitude);
        vector.add(longitude);
        return vector;
    }
}
