package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Vector;

/***
 * uncompressed  ::=  SEQUENCE {
 *      x  OCTET STRING (SIZE (32)),
 *      y  OCTET STRING (SIZE (32))
 *  }
 */
public class Uncompressed extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(Uncompressed.class);
    private OctetString x;
    private OctetString y;

    public Uncompressed() {
        super(false, false);
    }

    public static Uncompressed getInstance(byte[] data) {
        //ByteArrayUtils.printHexBinary(logger, "Uncompressed start data ", data);
        OctetString x = new OctetString();
        x.setLength(32);
        byte[] goal = new byte[32];
        System.arraycopy(data, 0, goal, 0, goal.length);
        x.setString(goal);
        OctetString y = new OctetString();
        //ByteArrayUtils.printHexBinary(logger, "Uncompressed x data ", goal);
        y.setLength(32);
        goal = new byte[32];
        System.arraycopy(data, 32, goal, 0, goal.length);
        y.setString(goal);
        //ByteArrayUtils.printHexBinary(logger, "Uncompressed y data ", goal);
        Uncompressed uncompressed = new Uncompressed();
        uncompressed.setX(x);
        uncompressed.setY(y);
        goal = new byte[data.length - 64];
        System.arraycopy(data, 64, goal, 0, goal.length);
        uncompressed.setGoal(goal);
        //ByteArrayUtils.printHexBinary(logger, "Uncompressed lave data ", data);
        return uncompressed;
    }

    public OctetString getX() {
        return x;
    }

    public void setX(OctetString x) {
        this.x = x;
    }

    public void setX(byte[] x) {
        this.x = new OctetString();
        this.x.setLength(32);
        this.x.setString(x);
    }

    public OctetString getY() {
        return y;
    }

    public void setY(OctetString y) {
        this.y = y;
    }

    public void setY(byte[] y) {
        this.y = new OctetString();
        this.y.setLength(32);
        this.y.setString(y);
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(x);
        vector.add(y);
        return vector;
    }
}
