package com.xdja.pki.oer.gbt.asn1;


import com.xdja.pki.oer.base.BitByte;
import com.xdja.pki.oer.base.Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

/***
 * -- 6.2.2.6 有效性限定
 *
 * ValidityRestriction ::= SEQUENCE {
 *     validityPeriod ValidityPeriod,
 *     region GeographicRegion OPTIONAL,
 *     ...
 * }
 *
 */
public class ValidityRestriction extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ValidityRestriction.class);
    private ValidityPeriod validityPeriod;
    private GeographicRegion geographicRegion;

    public ValidityRestriction() {
        super(true, true);
    }

    public static ValidityRestriction getInstance(byte[] data) throws Exception {
        //ByteArrayUtils.printHexBinary(logger, "ValidityRestriction start data", data);
        ValidityRestriction validityRestriction = new ValidityRestriction();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        List<Integer> integers = BitByte.setBit(choice.intValue()).readIndexes();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        ValidityPeriod validityPeriod = ValidityPeriod.getInstance(data);
        data = validityPeriod.getGoal();
        //ByteArrayUtils.printHexBinary(logger, "lave data", data);
        validityRestriction.setValidityPeriod(validityPeriod);
        //扩展
        if (integers.contains(0)){

        }
        if (integers.contains(1)){
            GeographicRegion geographicRegion = GeographicRegion.getInstance(data);
            validityRestriction.setGeographicRegion(geographicRegion);
            data = geographicRegion.getGoal();
        }
        validityRestriction.setGoal(data);
        return validityRestriction;
    }

    public ValidityPeriod getValidityPeriod() {
        return validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public GeographicRegion getGeographicRegion() {
        return geographicRegion;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        if (this.geographicRegion != null) {
            this.addOptional(Arrays.asList(7));
        }
        vector.add(validityPeriod);
        vector.add(geographicRegion);

        return vector;
    }
}
