package com.xdja.pki.oer.gbt.asn1.data;

import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.*;

/**
 * @ClassName ATTbsCertBuilder
 */
public class ATTbsCertBuilder {
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;

    private GeographicRegion geographicRegion;

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    public ATTbsCert build(String subjectName) throws Exception {
        ATTbsCert atTbsCert = new ATTbsCert();
        SubjectInfo subjectInfo = new SubjectInfo();
        subjectInfo.setSubjectType(new SubjectType(SubjectType.PSEUDONYM_CERTIFICATE));
        subjectInfo.setSubjectName(subjectName.getBytes());
        atTbsCert.setSubjectInfo(subjectInfo);
        ATSubjectAttributes subjectAttribute = new ATSubjectAttributes();
        subjectAttribute.setAssuranceLevel(new SubjectAssurance("0".getBytes()));
        if (itsAidList != null) {
            subjectAttribute.setItsAidList(itsAidList);
        }
        if (itsAidSspList != null) {
            subjectAttribute.setItsSspList(itsAidSspList);
        }
        atTbsCert.setSubjectAttributes(subjectAttribute);
        ValidityRestriction validityRestriction = new ValidityRestriction();
        ValidityPeriod validityPeriod = new ValidityPeriod();
        TimeStartAndEnd startAndEnd = new TimeStartAndEnd();
        long nowTime = TimeUtils.getNowTime();
        Time32 time32 = new Time32(nowTime);
        startAndEnd.setStartValidity(time32);
        long timeEnd = TimeUtils.getTimeAfterWeek(21);
        time32 = new Time32(timeEnd);
        startAndEnd.setEndValidity(time32);
        validityPeriod.setTimeStartAndEnd(startAndEnd);
        validityRestriction.setValidityPeriod(validityPeriod);
        if (geographicRegion != null) {
            validityRestriction.setGeographicRegion(geographicRegion);
        }
        atTbsCert.setValidityRestrictions(validityRestriction);
        return atTbsCert;
    }


}
