package com.xdja.pki.oer.gbt.asn1.data;

import com.xdja.pki.oer.gbt.asn1.*;

import java.security.PrivateKey;

/***
 * PCA 调用 生成 证书申请结构体
 */
public class AuthorizationValidationRequestEncBuilder {

    /**
     * PCA -> ECA 证书申请 请求 消息体生成
     *
     * @param pcaPrivateKey   PCA 证书私钥
     * @param pcaCertificate  PCA 证书
     * @param ecaCertificate  ECA 证书
     * @param sharedATRequest OBU -> PCA 请求中的 sharedATRequest
     * @param ecSignature     OBU -> PCA 请求中的 ecSignature
     * @return PCA -> ECA 证书申请 请求 消息体
     * @throws Exception 生成异常
     */
    public static SecuredMessage builder(
            PrivateKey pcaPrivateKey,
            Certificate pcaCertificate,
            Certificate ecaCertificate,
            SharedATRequest sharedATRequest,
            EcSignature ecSignature
    ) throws Exception {
        AuthorizationValidationRequest request = new AuthorizationValidationRequest(sharedATRequest, ecSignature);
        SecuredMessage sign = SecuredMessageBuilder.buildSignedDataSecuredMessage(
                ItsAidInt.NON_REGISTRATION_CERTIFICATE_REQUEST,
                pcaPrivateKey,
                pcaCertificate,
                request.getEncode()
        );
        //ByteArrayUtils.printHexBinary(null, "sign", sign.getEncode());
        SecuredMessage securedMessage = SecuredMessageBuilder.buildEncryptedDataSecuredMessage(ecaCertificate, sign.getEncode());
        //ByteArrayUtils.printHexBinary(null, "securedMessage", securedMessage.getEncode());
        return securedMessage;
    }

}