package com.xdja.pki.oer.gbt.asn1.data;

import com.xdja.pki.oer.base.Enumerated;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.bean.PKRecipientInfoType;
import com.xdja.pki.oer.gbt.asn1.utils.EccPointHolder;
import com.xdja.pki.oer.gbt.asn1.utils.KekBuilder;
import com.xdja.pki.oer.gbt.asn1.utils.TbsCertBuilder;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OEREccPoint;
import com.xdja.pki.oer.gbt.asn1.utils.enums.SubjectTypeEnum;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

/**
 * @ClassName CertDataBuilder
 */
public class CertDataBuilder {
    private static CalculateService calculateService = CalculateFactory.getInstance();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    CertRequest buildCertRequest(PublicKey certPublicKey, PublicKey temporaryPublic, String itsId, String subjectName, Enumerated.Value subjectTypeValue) throws Exception {
        TbsCertBuilder tbsCertBuilder = new TbsCertBuilder();
        SequenceOfItsAidList sequenceOfItsAidList = new SequenceOfItsAidList();
        sequenceOfItsAidList.addItsAid(ItsAid.TRAFFIC_LIGHT_APPLICATION);
        sequenceOfItsAidList.addItsAid(ItsAid.NON_REGISTRATION_CERTIFICATE_REQUEST);
        sequenceOfItsAidList.addItsAid(ItsAid.REGISTRATION_CERTIFICATE_RESPONSE);
        tbsCertBuilder.setItsAidList(sequenceOfItsAidList);
        GeographicRegion geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion sequenceOfRectangularRegion = new SequenceOfRectangularRegion();
        RectangularRegion rectangularRegion = new RectangularRegion();
        TwoDLocation twoDLocation = new TwoDLocation();
        twoDLocation.setLongitude(new Longitude(57834));
        twoDLocation.setLatitude(new Latitude(4897202));
        rectangularRegion.setSouthEast(twoDLocation);
        twoDLocation.setLongitude(new Longitude(547834));
        twoDLocation.setLatitude(new Latitude(985434));
        rectangularRegion.setNorthWest(twoDLocation);
        sequenceOfRectangularRegion.addRectangularRegion(rectangularRegion);
        geographicRegion.setRectangularRegion(sequenceOfRectangularRegion);
        tbsCertBuilder.setGeographicRegion(geographicRegion);
        TbsCert tbsCert = tbsCertBuilder.build(certPublicKey, certPublicKey, subjectName, SubjectTypeEnum.getSubjectTypeEnum(subjectTypeValue.getIndex()));
        CertRequest certRequest = new CertRequest();
        OctetString id = new OctetString();
        id.setString(itsId.getBytes());
        byte[] decode = Hex.decode("33303832303331313330383230314639");
        OctetString octetString = new OctetString();
        octetString.setString(decode);
        certRequest.setItsId(decode);
        long nowTime = TimeUtils.getNowTime();
        Time32 currentTime = new Time32(nowTime);
        certRequest.setCurrentTime(currentTime);
        certRequest.setTbsCertData(tbsCert);
        PublicEncryptionKey publicEncryptionKey = new PublicEncryptionKey();
        publicEncryptionKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        publicEncryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
        Uncompressed uncompressed = new Uncompressed();
        ECPublicKey ecPublicKey = (ECPublicKey) temporaryPublic;
        byte[] x = BigIntegers.asUnsignedByteArray(ecPublicKey.getW().getAffineX());
        byte[] y = BigIntegers.asUnsignedByteArray(ecPublicKey.getW().getAffineY());
        uncompressed.setX(x);
        uncompressed.setY(y);
        EccPoint eccPoint = new EccPoint();
        eccPoint.setUncompressed(uncompressed);
        publicEncryptionKey.setPublicKey(eccPoint);
        certRequest.setEncryptionKey(publicEncryptionKey);
        //ByteArrayUtils.printHexBinary(null, "certRequest", certRequest.getEncode());
        return certRequest;
    }

    SecuredMessage buildSecuredMessage(CertRequest certRequest, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        return buildSecuredMessage(certRequest.getEncode(), certRequest.getEncryptionKey().getPublicKey(), isSignedDataRecip, key, data);
    }

    SecuredMessage buildSecuredMessage(Certificate pcaCert, EccPoint publicKey, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        return buildSecuredMessage(pcaCert.getEncode(), publicKey, isSignedDataRecip, key, data);
    }

    SecuredMessage buildSecuredMessage(byte[] signData, EccPoint eccPoint, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        OEREccPoint oerEccPoint = EccPointHolder.build(eccPoint.getEncode());
        PublicKey publicKey = oerEccPoint.getPublicKey();
        return buildSecuredMessage(signData, publicKey, isSignedDataRecip, key, data);
    }

    SecuredMessage buildSecuredMessage(byte[] signData, PublicKey publicKey, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        PKRecipientInfo pkRecipientInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        pkRecipientInfo.setHashAlg(hashAlg);
//        byte[] certReqHash = BCUtils.sm3DigestByBC(pcaCert.getEncode());
        byte[] certReqHash = calculateService.sm3Hash(signData);
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certReqHash, certReqHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        //ByteArrayUtils.printHexBinary(null, "hashID data ", certHashId8);
        HashedId8 recipientId = new HashedId8(certHashId8);
        //EnrollmentCertRespData->payload->encData->recipients->pkRecipientInfo->recipientId赋值，
        pkRecipientInfo.setRecipientId(recipientId);
        //构建kek
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        pkRecipientInfo.setKek(kek);
        EncryptedData encData = new EncryptedData();
        SequenceOfRecipientInfo recipients = new SequenceOfRecipientInfo();
        RecipientInfo recipientInfo;
        if (isSignedDataRecip) {
            recipientInfo = new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.SIGNEDDATA_RECIPINFO);
        } else {
            recipientInfo = new RecipientInfo(pkRecipientInfo, PKRecipientInfoType.CERT_RECIPINFO);
        }
        recipients.addRecipientInfo(recipientInfo);
        encData.setRecipients(recipients);
        //使用传入的key进行ECB加密数据
//        byte[] bytes = GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf(true, SdfCryptoType.YUNHSM,
//                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, key, SdfAlgIdSymmetric.SGD_SM4_ECB, data);
        byte[] bytes = calculateService.sm4Encrypt(key, data);
        //ByteArrayUtils.printHexBinary(null, "BCUtils bytes", bytes);
        CipherText cipherData = new CipherText();
        cipherData.setString(bytes);
        SymmetricCipherText cipherText = new SymmetricCipherText(cipherData);
        //写入密文
        encData.setCipherText(cipherText);
        Payload payload = new Payload(encData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}
