package com.xdja.pki.oer.gbt.asn1.data;

import com.xdja.pki.oer.gbt.asn1.CertRequest;
import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

import java.security.PublicKey;

/***
 *  *NormalCertRequestSign ::= SecureMessage(WITH COMPONENTS { ...,
 *  * 	version(2),
 *  * 	payload(WITH COMPONENTS { ...,
 *  * 		signedData(WITH COMPONENTS { ...,
 *  * 			signer(WITH COMPONENTS {
 *  * 				SequenceOfCertificate(SIZE(1))
 *  *                        }),
 *  * 			tbs(WITH COMPONENTS { ...,
 *  * 				headerInfo(WITH COMPONENTS { ...,
 *  * 					itsAid(40963),
 *  * 					hashAlg PRESENT,
 *  * 					genTime PRESENT,
 *  * 					expiryTime ABSENT,
 *  * 					digest ABSENT,
 *  * 					encKey  ABSENT
 *  *                }),
 *  * 				data( CONTAINING NormalCertRequestEnc ),
 *  * 				extHash  ABSENT
 *  *            })* 		})
 *  *    })
 *  * })
 *  * NormalCertRequestEnc ::= SecureMessage(WITH COMPONENTS { ...,
 *  * 	version(2),
 *  * 	payload(WITH COMPONENTS { ...,
 *  * 		encData(WITH COMPONENTS { ...,
 *  * 			recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 *  * 				RecipientInfo(WITH COMPONENTS {
 *  * 					certRecipInfo
 *  *                                })* 			}        ))
 *  *    })
 *  * 	})
 *  * })
 *  *
 */
public class NormalCertRequestEnc extends CertDataBuilder {
    /**
     * @param certRequest 证书请求
     * @param key         对称密钥 16位
     * @return NormalCertRespData   F.3.2　非注册证书应答数据格式
     */
    public SecuredMessage build(CertRequest certRequest, PublicKey publicKey, byte[] key) throws Exception {
        return buildSecuredMessage(certRequest, publicKey,false, key, certRequest.getEncode());
    }


    private SecuredMessage buildSecuredMessage(CertRequest certRequest, PublicKey publicKey, boolean isSignedDataRecip, byte[] key, byte[] data) throws Exception {
       CertDataBuilder certDataBuilder = new CertDataBuilder();
       return certDataBuilder.buildSecuredMessage(certRequest.getEncode(),publicKey,isSignedDataRecip,key,data);
    }
}
