package com.xdja.pki.oer.gbt.asn1.data;


import com.xdja.pki.oer.gbt.asn1.Certificate;
import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

import java.security.PrivateKey;

/***
 * NormalCertResp ::= SecureMessage(WITH COMPONENTS { ...,
 * 	version(2),
 * 	payload(WITH COMPONENTS { ...,
 * 		signedData(WITH COMPONENTS { ...,
 * 			signer(WITH COMPONENTS {
 * 				SequenceOfCertificate(SIZE(1))
 *                        }),
 * 			tbs(WITH COMPONENTS { ...,
 * 				headerInfo(WITH COMPONENTS { ...,
 * 					itsAid(40964),
 * 					hashAlg PRESENT,
 * 					genTime PRESENT,
 * 					expiryTime ABSENT,
 * 					digest ABSENT,
 * 					encKey  ABSENT
 *                }),
 * 				data( CONTAINING NormalCertRespData ),
 * 				extHash  ABSENT
 *            })* 		})
 *    })
 * })
 */
public class NormalCertRespBuilder extends SecuredMessageBuild {
    /**
     * @param privateKey  私钥签名使用
     * @param respData    安全信息内部包的安全信息
     * @param certificate 签名者证书
     * @return EnrollmentCertRequest   F.2.1　注册证书请求数据格式
     */
    public SecuredMessage build(PrivateKey privateKey, SecuredMessage respData, Certificate certificate) throws Exception {
        return super.build(privateKey, respData, 40964, certificate);
    }
}
