package com.xdja.pki.oer.gbt.asn1.data;

import com.xdja.pki.oer.base.Int;
import com.xdja.pki.oer.base.Null;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.utils.SignatureBuilder;

import java.security.PrivateKey;

/***
 *---2. 请求数据
 * PseudonymCertRequestSign := SecuredMessage
 * SecuredMessage ::= SEQUENCE{
 *     version  Uint8,
 *     payload  Payload
 * }
 * SignedData ::= SEQUENCE{
 *     signer  SignerInfo,  ---self
 *     tbs     TBSData,
 *     sign    Signature ---要申请“假名证书”的签名私钥签名，原文为 "证书hash（应该是对空置的hash 先不做处理 填充32个0） + tbs oer编码 hash"
 * }
 * SignerInfo ::= CHOICE {
 *     self                NULL, ---自签名消息
 *     certificate         SequenceOfCertificate,
 *     certificateDigest   CertificateDigest,
 *     ...
 * };
 * TBSData ::= SEQUENCE{
 *     headerInfo  HeaderInfo,   ---和之前的一样
 *     data        OCTET STRING(SIZE(0..MAX))  Optional, ---InnerATRequest
 *     extHash     OCTET STRING(SIZE(32))  Optional,  --无
 * }
 */
public class PseudonymCertRequestSignBuilder {
    private static CalculateService calculateService = CalculateFactory.getInstance();

    /**
     * @param privateKey innerATRequest里边签名公钥对应的私钥
     */
    public static SecuredMessage build(PrivateKey privateKey, InnerATRequest innerATRequest) throws Exception {
        SignedData signedData = new SignedData();
        //自签名
        signedData.setSignerInfo(new SignerInfo(new Null()));
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(new Int(40965));
        headerInfo.setGenTime(new Time64(TimeUtils.getNowTime() * 1000L));
        headerInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
        TBSData tbsData = new TBSData();
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(innerATRequest.getEncode());
        //byte[] tbsHash = BCUtils.sm3DigestByBC(tbsData.getEncode());
        byte[] tbsHash = calculateService.sm3Hash(tbsData.getEncode());
        byte[] nullHash = calculateService.sm3Hash("".getBytes());
        byte[] data = ByteArrayUtils.buildUpByte(tbsHash, nullHash);
        Signature signature = SignatureBuilder.build(privateKey, data);
        signedData.setTbs(tbsData);
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        SecuredMessage securedMessage = new SecuredMessage();
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}
