
package com.xdja.pki.oer.gbt.asn1.data;


import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.oer.base.Int;
import com.xdja.pki.oer.base.Null;
import com.xdja.pki.oer.base.OERObject;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.utils.SignatureBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.PrivateKey;

/**
 *
 */
public class SecuredMessageBuild {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * @param privateKey   签名私钥
     * @param oerObject    待签的数据 TBSData里边的data 即传送消息
     * @param certificates 构建者签名证书（当消息为证书请求时候，不需要传该参数）
     * @return SecuredMessage 安全消息体
     */
    public SecuredMessage build(PrivateKey privateKey, OERObject oerObject, int itsAidVaule, Certificate... certificates) throws Exception {
        //ByteArrayUtils.printHexBinary(0, "SecuredMessage SEQUENCE", null);
        //ByteArrayUtils.printHexBinary(1, "Version   2", null);
        //ByteArrayUtils.printHexBinary(1, "PayLoad", null);
        SignerInfo signerInfo;
        // 证书请求应该为自签名
        byte[] hash;
        SignedData signedData = new SignedData();
        if (oerObject instanceof CertRequest) {
            signerInfo = new SignerInfo(new Null());
            hash = GMSSLSM3DigestUtils.digestByYunhsm("".getBytes());
        } else if (oerObject instanceof SecuredMessage) {
            try {
                SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
                sequenceOfCertificate.addCertificate(certificates[0]);
                signerInfo = new SignerInfo(sequenceOfCertificate);
                hash = GMSSLSM3DigestUtils.digestByYunhsm(certificates[0].getEncode());
            }catch (Exception e){
                signerInfo = new SignerInfo(new Null());
                hash = GMSSLSM3DigestUtils.digestByYunhsm("".getBytes());
            }
        } else {
            throw new Exception("can't support " + oerObject.getClass() + " type");
        }
        //ByteArrayUtils.printHexBinary(2, "SignedData", null);
        signedData.setSignerInfo(signerInfo);
        //ByteArrayUtils.printHexBinary(3, "SignerInfo", signerInfo.getEncode());
        TBSData tbs = new TBSData();
        //ByteArrayUtils.printHexBinary(2, "TBSData", null);
        //拼凑headInfo
        //ByteArrayUtils.printHexBinary(3, "HeaderInfo", null);
        HeaderInfo headerInfo = new HeaderInfo();
        Int itsAid = new Int(itsAidVaule);
        //ByteArrayUtils.printHexBinary(4, "itsAid    ", null);
        //ByteArrayUtils.printHexBinary(logger, "itsAid", itsAid.getEncode());
        headerInfo.setItsAid(itsAid);
        //ByteArrayUtils.printHexBinary(logger, "HeaderInfo", headerInfo.getEncode());
        headerInfo.setHashAlg(new HashAlgorithm(HashAlgorithm.SGD_SM3));
        //ByteArrayUtils.printHexBinary(4, "HashAlgorithm", null);
        //ByteArrayUtils.printHexBinary(5, "HashAlgorithm.SGD_SM3", null);
        long nowTime = TimeUtils.getNowTime() * 1000L;
        Time64 genTime = new Time64(nowTime);
        //ByteArrayUtils.printHexBinary(4, "Time64", genTime.getEncode());
        headerInfo.setGenTime(genTime);
        tbs.setHeaderInfo(headerInfo);
        //ByteArrayUtils.printHexBinary(logger, "HeaderInfo", headerInfo.getEncode());
        //拼凑data
        tbs.setData(oerObject.getEncode());
        //ByteArrayUtils.printHexBinary(3, "data", oerObject.getEncode());
        signedData.setTbs(tbs);
        byte[] array = ByteArrayUtils.buildUpByte(GMSSLSM3DigestUtils.digestByYunhsm(tbs.getEncode()), hash);
        Signature signature = SignatureBuilder.build(privateKey, array);
        signedData.setSign(signature);
        //signedData拼凑完成
        Payload payload = new Payload(signedData);
        SecuredMessage securedMessage = new SecuredMessage();
        securedMessage.setPayload(payload);
        return securedMessage;
    }


}
