package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.base.Enumerated;
import com.xdja.pki.oer.base.Uint32;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERRevokeInfo;
import com.xdja.pki.oer.gbt.asn1.utils.enums.CertHashTypeEnum;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CRLBuilder {
    private CalculateService calculateService = CalculateFactory.getInstance();
    public CRL build(PrivateKey privateKey, long serial, byte[] issuedHash, List<byte[]> hashedId10s) throws Exception {
        List<OERRevokeInfo> oerRevokeInfos = new ArrayList<>();
        for (int i = 0; i < hashedId10s.size(); i++) {
            OERRevokeInfo oerRevokeInfo = new OERRevokeInfo();
            oerRevokeInfo.setExpireDate(new Date());
            oerRevokeInfo.setAlgorithm(CertHashTypeEnum.SGD_SM3);
            oerRevokeInfo.setIssueHashId10s(hashedId10s.get(i));
            oerRevokeInfos.add(oerRevokeInfo);
        }
        return build(privateKey, serial, oerRevokeInfos, issuedHash, new Date());
    }

    public CRL build(PrivateKey privateKey, long serial, List<OERRevokeInfo> oerRevokeInfos, byte[] issuedHash) throws Exception {
        return build(privateKey, serial, oerRevokeInfos, issuedHash, new Date());
    }

    public CRL build(PrivateKey privateKey, long serial, List<OERRevokeInfo> oerRevokeInfos, byte[] issuedHash, Date nexCrl) throws Exception {
        CRL crl = new CRL();
        IssuerId issuerId = new IssuerId();
        CertificateDigest certificateDigest = new CertificateDigest();
        HashAlgorithm hashAlgorithm = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certificateDigest.setHashAlgorithm(hashAlgorithm);
        byte[] hashId8 = ByteArrayUtils.subByteHashId(issuedHash, 8);
        HashedId8 hashedId8 = new HashedId8(hashId8);
        certificateDigest.setHashedId8(hashedId8);
        issuerId.setCertificateDigest(certificateDigest);
        crl.setIssuerId(issuerId);
        ToBeSignedCrl toBeSignedCrl = new ToBeSignedCrl();
        Uint32 crlSerial = new Uint32(serial);
        long nowTime = TimeUtils.getNowTime();
        Time32 issueDate = new Time32(nowTime);
        long nextTime = TimeUtils.getTimeFromDate(nexCrl);
        Time32 nextCrl = new Time32(nextTime);
        SequenceOfRevokeInfo sequenceOfRevokeInfo = new SequenceOfRevokeInfo();
        for (OERRevokeInfo oerRevokeInfo : oerRevokeInfos) {
            RevokeInfo revokeInfo = new RevokeInfo();
            HashAlgorithm rh = new HashAlgorithm(new Enumerated.Value(oerRevokeInfo.getAlgorithm().id, oerRevokeInfo.getAlgorithm().value));
            HashedId10 id = new HashedId10(oerRevokeInfo.getIssueHashId10s());
            revokeInfo.setHashAlgorithm(rh);
            revokeInfo.setHashedId10(id);
            revokeInfo.setExpiry(new Time32(TimeUtils.getTimeFromDate(oerRevokeInfo.getExpireDate())));
            sequenceOfRevokeInfo.addRevokeInfo(revokeInfo);
        }
        toBeSignedCrl.setCrlSerial(crlSerial);
        toBeSignedCrl.setIssueDate(issueDate);
        toBeSignedCrl.setNextCrl(nextCrl);
        toBeSignedCrl.setEntries(sequenceOfRevokeInfo);
        crl.setToBeSignedCrl(toBeSignedCrl);
        byte[] tbsHash = calculateService.sm3Hash(toBeSignedCrl.getEncode());
        byte[] hash = ByteArrayUtils.buildUpByte(tbsHash, issuedHash);
        Signature signature = SignatureBuilder.build(privateKey, hash);
        crl.setSignature(signature);
        return crl;
    }
}
