package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.CRL;
import com.xdja.pki.oer.gbt.asn1.HashedId8;
import com.xdja.pki.oer.gbt.asn1.RevokeInfo;
import com.xdja.pki.oer.gbt.asn1.SequenceOfRevokeInfo;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERCRL;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERRevokeInfo;
import org.bouncycastle.util.BigIntegers;

import java.util.ArrayList;
import java.util.List;


public class CRLHolder {

    private static CalculateService calculateService = CalculateFactory.getInstance();

    public static OERCRL build(byte[] data) throws Exception {
        CRL crl = CRL.getInstance(data);
        OERCRL oercrl = new OERCRL();
        try {
            HashedId8 hashedId8 = crl.getIssuerId().getCertificateDigest().getHashedId8();
            oercrl.setSignerHashId8(GMSSLByteArrayUtils.hexEncode(hashedId8.getString()));
        } catch (Exception e) {
            //
        }
        byte[] bytes = calculateService.sm3Hash(data);
        byte[] goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        oercrl.setSelfHashId8(GMSSLByteArrayUtils.hexEncode(goal));
        SequenceOfRevokeInfo entries = crl.getToBeSignedCrl().getEntries();
        List<OERRevokeInfo> infos = new ArrayList<>();
        for (RevokeInfo revokeInfo : entries.getRevokeInfos()) {
            OERRevokeInfo build = RevokeInfoHolder.build(revokeInfo.getEncode());
            infos.add(build);
        }
        oercrl.setList(infos);
        long issueDate = BigIntegers.fromUnsignedByteArray(crl.getToBeSignedCrl().getIssueDate().getEncode()).longValue();
        long nextDate = BigIntegers.fromUnsignedByteArray(crl.getToBeSignedCrl().getNextCrl().getEncode()).longValue();
        oercrl.setIssueDate(TimeUtils.getTime(issueDate));
        oercrl.setNextDate(TimeUtils.getTime(nextDate));
        oercrl.setCrlSerial(BigIntegers.fromUnsignedByteArray(crl.getToBeSignedCrl().getCrlSerial().getEncode()).longValue());
        return oercrl;
    }
}
