package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.Certificate;
import com.xdja.pki.oer.gbt.asn1.HashedId8;
import com.xdja.pki.oer.gbt.asn1.TbsCert;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERCertificate;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERTbsCert;
import com.xdja.pki.oer.gbt.asn1.utils.enums.CertHashTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.GeographicRegionTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.IssueIdTypeEnum;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;


/**
 * 获取证书详情
 */
public class CertificateHolder {
    private static CalculateService calculateService = CalculateFactory.getInstance();
    public static OERCertificate build(byte[] data) throws Exception {
        Certificate certificate = Certificate.getInstance(data);
        return build(certificate);
    }
    public static OERCertificate build(Certificate certificate) throws Exception {
        OERCertificate oerCertificate = new OERCertificate();
        int version = certificate.getVersion();
        TbsCert tbs = certificate.getTbsCert();
        OERTbsCert tbsCert = TbsCertHolder.build(tbs.getEncode());
        String signerHashId8 = "";
        byte[] encode = certificate.getIssuerId().getEncode();
        byte[] selfHash;
        if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x80) {
            BCECPublicKey publicKey = (BCECPublicKey) tbsCert.getSignPublicKey();
            if (publicKey.getParameters().getCurve() instanceof SM2P256V1Curve) {
                selfHash = calculateService.sm3Hash(certificate.getEncode());
            } else {
                selfHash = calculateService.sha256Hash(certificate.getEncode());
            }
            oerCertificate.setIssueIdType(IssueIdTypeEnum.NULL);
            byte[] goal = new byte[8];
            System.arraycopy(selfHash, selfHash.length - 8, goal, 0, goal.length);
            oerCertificate.setSignerHashId8(Hex.toHexString(goal));
        } else {
            HashedId8 hashedId8 = certificate.getIssuerId().getCertificateDigest().getHashedId8();
            signerHashId8 = GMSSLByteArrayUtils.hexEncode(hashedId8.getString());
            oerCertificate.setIssueIdType(IssueIdTypeEnum.CERTIFICATE_DIGEST);
            byte[] hashAlg = certificate.getIssuerId().getCertificateDigest().getHashAlgorithm().getEncode();
            BigInteger choice = BigIntegers.fromUnsignedByteArray(hashAlg, 0, 1);
            if (choice.intValue() == 0) {
                oerCertificate.setIssueIdAlg(CertHashTypeEnum.SGD_SM3);
                selfHash = calculateService.sm3Hash(certificate.getEncode());
            } else if (choice.intValue() == 1) {
                oerCertificate.setIssueIdAlg(CertHashTypeEnum.SHA_256);
                selfHash = calculateService.sha256Hash(certificate.getEncode());
            } else {
                throw new Exception("unsupported HashAlgorithm type" + choice.intValue());
            }
            oerCertificate.setSignerHashId8(signerHashId8);
        }
        byte[] hashid8 = new byte[8];
        System.arraycopy(selfHash, selfHash.length - 8, hashid8, 0, hashid8.length);
        byte[] hashId10 = new byte[10];
        System.arraycopy(selfHash, selfHash.length - 10, hashId10, 0, hashId10.length);
        oerCertificate.setSelfHashId10(Hex.toHexString(hashId10));
        oerCertificate.setSelfHashId8(Hex.toHexString(hashid8));
        oerCertificate.setVersion(version);
        oerCertificate.setTbsCert(tbs);
        oerCertificate.setSubjectName(tbsCert.getSubjectName());
        oerCertificate.setSignPublicKey(tbsCert.getSignPublicKey());
        oerCertificate.setEncPublicKey(tbsCert.getEncPublic());
        oerCertificate.setSubjectType(tbsCert.getSubjectType());
        oerCertificate.setStartTime(tbsCert.getStartTime());
        oerCertificate.setEndTime(tbsCert.getEndTime());
        oerCertificate.setType(tbsCert.getType());
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.CIRCULAR_REGION.id) {
            oerCertificate.setCircularRegion(tbsCert.getCircularRegion());
        }
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.RECTANGULAR_REGION.id) {
            oerCertificate.setRectangularRegions(tbsCert.getRectangularRegions());
        }
        if (tbsCert.getRegionType().id == GeographicRegionTypeEnum.POLYGONAL_REGION.id) {
            oerCertificate.setPolygonalRegions(tbsCert.getPolygonalRegions());
        }
        oerCertificate.setItsAid(tbsCert.getItsAid());
        oerCertificate.setItsAidSspList(tbsCert.getItsAidSspList());
        oerCertificate.setRegionType(tbsCert.getRegionType());
        oerCertificate.setStartDate(tbsCert.getStartDate());
        oerCertificate.setEndDate(tbsCert.getEndDate());
        oerCertificate.setBatcType(tbsCert.getBatcType());
        oerCertificate.setSignPublicKeyStr(tbsCert.getSignPublicKeyStr());
        oerCertificate.setSignEccPointType(tbsCert.getSignEccPointType());
        oerCertificate.setEncPublicKeyStr(tbsCert.getEncPublicKeyStr());
        oerCertificate.setEncEccPointType(tbsCert.getEncEccPointType());
        oerCertificate.setContent(Hex.toHexString(certificate.getEncode()));
        return oerCertificate;
    }
}
