package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccCurveTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccPointTypeEnum;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;

import java.security.interfaces.ECPublicKey;

/**
 * @ClassName ECPublicUtils
 * @Description TODO
 * @Date 2020/3/23 15:05
 * @Author FengZhen
 */
public class ECPublicUtils {
    public static final String ECC_SM2_NAME = "sm2p256v1";
    public static final String BRAINPOOL_P_256_R1 = "brainpoolP256r1";
    public static final String NIST_P_256 = "secp256r1";

    /**
     * @param isOdd 是否为奇数
     * @param x     ECCPublicKey 的 X分量
     */
    public static ECPublicKey decodePoint(boolean isOdd, byte[] x, EccCurveTypeEnum typeEnum) {
        String curveName;
        if (typeEnum == EccCurveTypeEnum.SGD_SM2) {
            curveName = ECC_SM2_NAME;
        } else if (typeEnum == EccCurveTypeEnum.NIST_P_256) {
            curveName = NIST_P_256;
        } else {
            curveName = BRAINPOOL_P_256_R1;
        }
        ECParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(curveName);
        ECCurve curve = ecParameterSpec.getCurve();
        byte[] encode;
        if (isOdd) {
            byte[] bytes = new byte[]{3};
            encode = ByteArrayUtils.buildUpByte(bytes, x);
        } else {
            byte[] bytes = new byte[]{2};
            encode = ByteArrayUtils.buildUpByte(bytes, x);
        }
        org.bouncycastle.math.ec.ECPoint ecPoint = curve.decodePoint(encode);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
        return new BCECPublicKey(curveName, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    /**
     * @param type 公钥类型
     * @param data 公钥数据十六进制
     */
    public static ECPublicKey decodePoint(EccPointTypeEnum type, byte[] data, String stdName) throws Exception {
        ECParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec(stdName);
        ECCurve curve = ecParameterSpec.getCurve();
        byte[] encode;
        byte[] bytes;
        switch (type) {
            case UNCOMPRESSED:
                bytes = new byte[]{4};
                encode = ByteArrayUtils.buildUpByte(bytes, data);
                break;
            case COMPRESSED_Y0:
                bytes = new byte[]{2};
                encode = ByteArrayUtils.buildUpByte(bytes, data);
                break;
            case COMPRESSED_Y1:
                bytes = new byte[]{3};
                encode = ByteArrayUtils.buildUpByte(bytes, data);
                break;
            default:
                throw new Exception("eccPoint type is error " + type.value);
        }
        org.bouncycastle.math.ec.ECPoint ecPoint = curve.decodePoint(encode);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
        return new BCECPublicKey(stdName, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }
}
